% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covlmc_as.R
\name{as_covlmc}
\alias{as_covlmc}
\alias{as_covlmc.tune_covlmc}
\title{Convert an object to a Variable Length Markov Chain with covariates (coVLMC)}
\usage{
as_covlmc(x, ...)

\method{as_covlmc}{tune_covlmc}(x, ...)
}
\arguments{
\item{x}{an object to convert into a covlmc.}

\item{...}{additional arguments for conversion functions.}
}
\value{
a covlmc
}
\description{
This generic function converts an object into a covlmc.
}
\examples{
## conversion from the results of tune_covlmc
pc <- powerconsumption[powerconsumption$week == 5, ]
dts <- cut(pc$active_power, breaks = c(0, quantile(pc$active_power, probs = c(0.5, 1))))
dts_cov <- data.frame(day_night = (pc$hour >= 7 & pc$hour <= 17))
dts_best_model_tune <- tune_covlmc(dts, dts_cov)
dts_best_model <- as_covlmc(dts_best_model_tune)
draw(dts_best_model)
}
\seealso{
\code{\link[=tune_covlmc]{tune_covlmc()}}
}
