% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_functions.R
\name{getFeedingLevel}
\alias{getFeedingLevel}
\title{Get feeding level}
\usage{
getFeedingLevel(object, n, n_pp, n_other, time_range, drop = FALSE, ...)
}
\arguments{
\item{object}{A \code{MizerParams} object or a \code{MizerSim} object}

\item{n}{A matrix of species abundances (species x size).}

\item{n_pp}{A vector of the resource abundance by size}

\item{n_other}{A list of abundances for other dynamical components of the
ecosystem}

\item{time_range}{A vector of times. Only the range of times is relevant,
i.e., all times between the smallest and largest will be selected.
The time_range can be character or numeric.}

\item{drop}{If \code{TRUE} then any dimension of length 1 will be removed
from the returned array.}

\item{...}{Unused}
}
\value{
If a \code{MizerParams} object is passed in, the function returns a two
dimensional array (predator species x predator size) based on the
abundances also passed in.
If a \code{MizerSim} object is passed in, the function returns a three
dimensional array (time step x predator species x predator size) with the
feeding level calculated at every time step in the simulation.
If \code{drop = TRUE} then the dimension of length 1 will be removed from
the returned array.
}
\description{
Returns the feeding level.
By default this function uses \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}} to calculate
the feeding level, but this can be overruled via \code{\link[=setRateFunction]{setRateFunction()}}.
}
\section{Feeding level}{

The feeding level \eqn{f_i(w)} is the
proportion of its maximum intake rate at which the predator is actually
taking in fish. It is calculated from the encounter rate \eqn{E_i} and the
maximum intake rate \eqn{h_i(w)} as
\deqn{f_i(w) = \frac{E_i(w)}{E_i(w)+h_i(w)}.}{E_i(w)/(E_i(w)+h_i(w)).}
The encounter rate \eqn{E_i} is passed as an argument or calculated with
\code{\link[=getEncounter]{getEncounter()}}. The maximum intake rate \eqn{h_i(w)} is
taken from the \code{params} object, and is set with
\code{\link[=setMaxIntakeRate]{setMaxIntakeRate()}}.
As a consequence of the above expression for the feeding level,
\eqn{1-f_i(w)} is the proportion of the food available to it that the
predator actually consumes.
}

\section{Your own feeding level function}{

By default \code{\link[=getFeedingLevel]{getFeedingLevel()}} calls \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}}. However you can
replace this with your own alternative feeding level function. If
your function is called \code{"myFeedingLevel"} then you register it in a MizerParams
object \code{params} with\preformatted{params <- setRateFunction(params, "FeedingLevel", "myFeedingLevel")
}

Your function will then be called instead of \code{\link[=mizerFeedingLevel]{mizerFeedingLevel()}}, with the
same arguments.
}

\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# Get initial feeding level
fl <- getFeedingLevel(params)
# Project with constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
# Get the feeding level at all saved time steps
fl <- getFeedingLevel(sim)
# Get the feeding level for years 15 - 20
fl <- getFeedingLevel(sim, time_range = c(15, 20))
}
}
\seealso{
Other rate functions: 
\code{\link{getEGrowth}()},
\code{\link{getEReproAndGrowth}()},
\code{\link{getERepro}()},
\code{\link{getEncounter}()},
\code{\link{getFMortGear}()},
\code{\link{getFMort}()},
\code{\link{getMort}()},
\code{\link{getPredMort}()},
\code{\link{getPredRate}()},
\code{\link{getRDD}()},
\code{\link{getRDI}()},
\code{\link{getResourceMort}()}
}
\concept{rate functions}
