% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_methods.R
\name{getN}
\alias{getN}
\title{Calculate the number of individuals within a size range}
\usage{
getN(sim, ...)
}
\arguments{
\item{sim}{An object of class \code{MizerSim}.}

\item{...}{
  Arguments passed on to \code{\link[=get_size_range_array]{get_size_range_array}}
  \describe{
    \item{\code{min_w}}{Smallest weight in size range. Defaults to smallest weight in
the model.}
    \item{\code{max_w}}{Largest weight in size range. Defaults to largest weight in the
model.}
    \item{\code{min_l}}{Smallest length in size range. If supplied, this takes
precedence over \code{min_w}.}
    \item{\code{max_l}}{Largest length in size range. If supplied, this takes precedence
over \code{max_w}.}
  }}
}
\value{
An array containing the total numbers (time x species)
}
\description{
Calculates the number of individuals within user-defined size limits, for
each time and each species in the \code{MizerSim} object. The default option
is to use the whole size range. You can specify minimum and maximum weight or
lengths for the species. Lengths take precedence over weights (i.e. if both
min_l and min_w are supplied, only min_l will be used)
}
\examples{
\dontrun{
params <- newMultispeciesParams(NS_species_params_gears, inter)
# With constant fishing effort for all gears for 20 time steps
sim <- project(params, t_max = 20, effort = 0.5)
getN(sim)
getN(sim, min_w = 10, max_w = 1000)
}
}
\seealso{
Other summary functions: 
\code{\link{getBiomass}()},
\code{\link{getDiet}()},
\code{\link{getGrowthCurves}()},
\code{\link{getSSB}()},
\code{\link{getYieldGear}()},
\code{\link{getYield}()}
}
\concept{summary functions}
\concept{summary_function}
