% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInitialValues.R
\name{initialN<-}
\alias{initialN<-}
\alias{initialN}
\title{Initial values for fish spectra}
\usage{
initialN(params) <- value

initialN(object)
}
\arguments{
\item{params}{A MizerParams object}

\item{value}{A matrix with dimensions species x size holding the initial
number densities for the fish spectra.}

\item{object}{An object of class MizerParams or MizerSim}
}
\value{
A matrix with dimensions species x size holding the initial number
densities for the fish spectra.
}
\description{
Values used as starting values for simulations with \code{project()}.
}
\examples{
# Doubling abundance of Cod in the initial state of the North Sea model
params <- NS_params
initialN(params)["Cod", ] <- 2 * initialN(params)["Cod", ]
# Calculating the corresponding initial biomass
biomass <- initialN(params)["Cod", ] * dw(NS_params) * w(NS_params)
# Of course this initial state will no longer be a steady state
params <- steady(params)
}
