% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{endpoints}
\alias{endpoints}
\title{Function to calculate endpoints for further use from kinetic models fitted
with mkinfit}
\usage{
endpoints(fit)
}
\arguments{
\item{fit}{An object of class \code{\link{mkinfit}}.}
}
\value{
A list with the components mentioned above.
}
\description{
This function calculates DT50 and DT90 values as well as formation fractions
from kinetic models fitted with mkinfit. If the SFORB model was specified
for one of the parents or metabolites, the Eigenvalues are returned. These
are equivalent to the rate constantes of the DFOP model, but with the
advantage that the SFORB model can also be used for metabolites.
}
\note{
The function is used internally by \code{\link{summary.mkinfit}}.
}
\examples{

  fit <- mkinfit("FOMC", FOCUS_2006_C, quiet = TRUE)
  endpoints(fit)  

}
\author{
Johannes Ranke
}
\keyword{manip}
