# From the RAR 2018, see the help file for dimethenamid_2018
# Metabolite residues for time zero were added to the parent value (Wendt 1997)
library(mkin)
dimethenamid_2018 <- mkindsg$new(
  title = "Aerobic soil degradation data on dimethenamid-P from the EU assessment in 2018",
  ds = list(
    mkinds$new("Calke", # p. 27
      mkin_wide_to_long(
        data.frame(
          t = c(0, 0, 14, 30, 59, 120, 120),
          DMTAP = c(95.8, 98.7, 60.5, 39.1, 15.2, 4.8, 4.6),
          M23 = c(NA, NA, 4.1, 5.3, 6.0, 4.3, 4.1),
          M27 = c(NA, NA, 1.5, 2.4, 3.2, 3.8, 3.7),
          M31 = c(NA, NA, 2.0, 2.1, 2.2, 1.8, 2.1)
        )
      )
    ),
    mkinds$new("Borstel 1", # p. 22
      mkin_wide_to_long(
        data.frame(
          t = c(0, 28, 58, 89, 119),
          DMTAP = c(100.5, 51.4, 26.8, 15.7, 7.9)
        )
      )
    ),
    mkinds$new("Borstel 2", # p. 19/20
      mkin_wide_to_long(
        data.frame(
          t = rep(c(0, 2, 7, 14, 28, 58, 89, 119), each = 2),
          DMTAP = c(100.5, 99.6, 91.9, 91.3, 81.8, 82.1, 69.1, 68.0, 51.4, 51.4,
            27.6, 26.8, 15.7, 15.3, 7.9, 8.1),
          M23 = c(NA, NA, 0.4, 0.5, 1.2, 1.3, 2.8, 2.0, 2.9, 4.9, 12.2, 12.2,
            12.2, 12.0, 10.4, 11.6),
          M27 = c(NA, NA, NA, 0.3, 0.8, 0.9, 1.4, 1.4, 2.7, 2.6, 4.4, 4.7,
            5.4, 5.2, 5.4, 5.4),
          M31 = c(NA, NA, NA, 0.1, 1.0, 0.9, 2.0, 2.5, 4.3, 3.2, 4.3, 4.8,
            5.0, 5.1, 4.3, 4.4)
        )
      )
    ),
    mkinds$new("Elliot 1", # p. 15/16
      mkin_wide_to_long(
        data.frame(
          t = rep(c(0, 1, 3, 7, 14, 21, 28, 42, 56, 84, 119, 182), each = 2),
          DMTAP = c(96.2 + 1.3, 100.7, 86.4, 88.5, 69.8, 77.1, 59.0, 54.2, 31.3, 33.5,
            19.6, 20.9, 13.3, 15.8, 6.7, 8.7, 8.8, 8.7, 6.0, 4.4, 3.3, 2.8, 1.4, 1.8),
          M23 = c(rep(NA, 4), 2.8,  1.7,  4.3,  5.8,  8.2,  5.2, 5.1,  6.1,
            6.0,  6.0,  5.0,  4.2,  3.9,  2.9,  1.9,  1.5, 2.0,  2.3, 1.2, 1.9),
          M27 = c(rep(NA, 4), 2.3, 2.1, 4.0, 3.4, 6.6, 6.9, 8.2, 8.8, 9.7, 8.8,
            8.3, 9.2, 9.3, 8.5, 8.6, 6.0, 5.6, 4.5, 4.1, 3.9),
          M31 = c(rep(NA, 3), 1.5, 5.0, 2.4, 4.3, 5.0, 8.0, 7.7, 7.8, 6.5, 8.0,
            7.4, 6.9, 9.0, 5.5, 6.1, 6.1, 4.0, 3.1, 2.9, 1.8, 2.6)
        )
      )
    ),
    mkinds$new("Elliot 2", # p. 16
      mkin_wide_to_long(
        data.frame(
          t = rep(c(0, 1, 3, 7, 14, 21, 28, 42, 56, 84, 119, 182), each = 2),
          DMTA = c(93.4, 103.2, 89.2, 86.6, 78.2, 78.1, 55.6, 53.0, 33.7,
            33.2, 20.9, 19.9, 18.2, 12.7, 7.8, 9.0, 11.4, 9.0, 3.9, 4.4, 2.6,
            3.4, 2.0, 1.7),
          M23 = c(rep(NA, 4), 2.6, 2.4, 5.5, 5.6, 7.3, 6.5, 5.8, 7.7, 7.8, 7.3, 7.0,
            6.3, 4.3, 3.8, 2.6, 2.8, 1.6, 1.1, 1.4, 1.3),
          M27 = c(rep(NA, 4),  1.0, 2.6, 4.5, 4.6, 7.6, 6.7, 8.7, 7.6, 8.0,
            8.6, 7.4, 7.2, 10.3, 9.4, 6.5, 6.9, 4.6, 4.5, 4.3, 4.2),
          M31 = c(NA, NA, 1.3, NA,  3.1, 2.3, 3.4, 4.3, 7.8, 8.7, 7.7, 6.5,
            6.3, 8.7, 5.7, 4.2, 3.2, 4.2, 3.8, 4.0, 4.5, 4.5, 3.8, 2.3)
        )
      )
    ),
    mkinds$new("Flaach", # p. 13
      mkin_wide_to_long(
        data.frame(
          t = rep(c(0, 1, 3, 7, 14, 21, 28, 42, 56, 70, 84, 120), each = 3),
          DMTA = c(96.5, 96.8, 97.0, 82.9, 86.7, 87.4, 72.8, 69.9, 71.9, 51.4,
            52.9, 48.6, 28.5, 27.3, 27.5, 14.8, 13.4, 14.4, 7.7, 7.3, 8.1, 2,
            1.5, 1.9, 1.3, 1, 1.1, 0.9, 0.7, 0.7, 0.6, 0.4, 0.5, 0.4, 0.3,
            0.3),
          M23 = c(rep(NA, 3), 0.7, 0.7, 0.2, 2.2, 1.8, 1.6, 4.1, 4.2, 4.2, 7.5,
            7.1, 7.5, 8.4, 6.8, 8, 7.2, 7.2, 6.9, 4.9, 4.3, 4.5, 3.8, 3.1, 3.1,
            2.7, 2.3, 2.1, 1.6, 1.1, 1.3, 0.4, 0.4, 0.3),
          M27 = c(rep(NA, 3), 1.1, 1.1, 0.3, 2.6, 2.4, 2.3, 5, 5.9, 4.8, 8.5,
            8.5, 8.3, 9.3, 8.7, 9.1, 8.6, 8.5, 8.9, 8.1, 7.7, 7.4, 5.9, 6, 5.9,
            5.6, 5.2, 5.6, 4.3, 3.7, 3.9, 2.5, 2.4, 2.2),
          M31 = c(rep(NA, 3), 0.3, 0.3, 0.1, 0.7, 0.6, 0.7, 1.3, 1.2, 1.4,
            2.4, 2.1, 2.3, 3.3, 2.4, 2.6, 4, 3.6, 3.3, 2.1, 1.7, 1.8, 1.6, 1.6,
            1.4, 1.8, 1.5, 1.3, 1.2, 0.9, 1.1, 0.5, 0.5, 0.3)
        )
      )
    ),
    mkinds$new("BBA 2.2", # p. 10
      mkin_wide_to_long(
        data.frame(
          t = rep(c(0, 1, 3, 7, 14, 21, 28, 42, 56, 70, 84, 119), each = 2),
          DMTA = c(98.09, 98.77, 93.52, 92.03, 88.39, 87.18, 69.38, 71.06,
            45.21, 46.81, 30.54, 30.07, 21.60, 20.41, 9.10, 9.70, 6.58, 6.31,
            3.47, 3.52, 3.40, 3.67, 1.62, 1.62),
          M23 = c(NA, NA, 0.36, 0.4, 1.03, 1.07, 3.6, 3.66, 6.97, 7.22, 8.65,
            8.38, 9.1, 8.63, 7.63, 8.01, 6.4, 6.35, 5.35, 5.06, 5.14, 5.91,
            3.35, 2.87),
          M27 = c(NA, NA, 0.42, 0.47, 0.71, 0.82, 2.19, 2.28, 5.45, 5.19, 8.81,
            7.93,10.25,10.77,10.89,10.85,10.41,10.35, 9.92, 9.42, 9.15, 9.25,
            7.14, 7.13),
          M31 = c(NA, NA, 0.36, 0.33, 0.55, 0.64, 1.94, 1.62, 4.22, 4.37, 6.31,
            6.85, 7.05, 6.84, 6.53, 7.11, 6.06, 6.05, 5.5, 5.07, 4.94, 4.39,
            3.64, 3.55)
        )
      )
    ),
    mkinds$new("BBA 2.3", # p. 10
      mkin_wide_to_long(
        data.frame(
          t = rep(c(0, 1, 3, 7, 14, 21, 28, 42, 56, 70, 84, 119), each = 2),
          DMTA = c(99.33, 97.44, 93.73, 93.77, 87.84, 89.82, 71.61, 71.42,
            45.60, 45.42, 31.12, 31.68, 23.20, 24.13, 9.43, 9.82, 7.08, 8.64,
            4.41, 4.78, 4.92, 5.08, 2.13, 2.23),
          M23 = c(NA, NA, 0.18, 0.18, 0.52, 0.43, 1.19, 1.11, 2.26, 1.99, 2.81,
            2.83, 3.39, 3.56, 3.49, 3.28, 2.80, 2.97, 2.42, 2.51, 2.22, 1.95,
            1.28, 0.99),
          M27 = c(NA, NA,  0.5, 0.83, 1.25, 1.09, 3.28, 3.24, 7.17, 7.91, 10.15,
            9.55, 12.09, 11.89, 13.32, 12.05, 10.04, 10.78, 9.32, 9.62, 8.00,
            8.45, 5.71, 3.33),
          M31 = c(NA, NA, 0.47, 0.34, 1.00, 0.89, 3.58, 3.41, 8.74, 8.28, 9.67,
            8.95, 10.34, 10.00, 7.89, 8.13, 5.06, 5.54, 3.79, 4.11, 3.11, 2.98,
            1.78, 1.55)
        )
      )
    )
  ),
  # Soil data and temperatures from p. 25, p. 18 (Staudenmaier 2013 and 2009)
  # p. 14 (Wendt 1997), p. 12 (König 1995), p. 9 (König 1995)
  # Soil classification in the König studies was according to the German scheme,
  # but the FOCUS generic guidance suggests them to be equivalent to the USDA
  # classes with the same name
  meta = data.frame(
    study = c("Unsworth 2014", "Staudenmaier 2013", "Staudenmaier 2009",
      rep("Wendt 1997", 2), "König 1996", rep("König 1995", 2)),
    usda_soil_type = c("Sandy loam", rep("Sand", 2),
      rep("Clay loam", 2), "Sandy clay loam", "Loamy sand",
      "Sandy loam"),
    study_moisture_ref_type = c("pF2", rep("pF1", 2),
      rep("pF2.5", 2), rep("pF1", 3)),
    rel_moisture = c(1, rep(0.5, 2),
      rep(0.75, 2), rep(0.4, 3)),
    study_ref_moisture = c(NA, rep(23, 2), rep(33.37, 2), rep(NA, 3)),
    temperature = c(20, rep(20, 2),
      rep(23, 2), rep(20, 3))
  )
)
f_time_norm_focus(dimethenamid_2018)

save(dimethenamid_2018, file = "data/dimethenamid_2018.rda", version = 2)
