% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-client.R
\name{mlflow_client_log_artifact}
\alias{mlflow_client_log_artifact}
\title{Log Artifact}
\usage{
mlflow_client_log_artifact(client, run_id, path, artifact_path = NULL)
}
\arguments{
\item{client}{An `mlflow_client` object.}

\item{run_id}{Run ID.}

\item{path}{The file or directory to log as an artifact.}

\item{artifact_path}{Destination path within the run's artifact URI.}
}
\description{
Logs a specific file or directory as an artifact for a run.
}
\details{
The Tracking Client family of functions require an MLflow client to be
  specified explicitly. These functions allow for greater control of where the
  operations take place in terms of services and runs, but are more verbose
  compared to the Fluent API.

When logging to Amazon S3, ensure that the user has a proper policy
attached to it, for instance:

\code{
{
"Version": "2012-10-17",
"Statement": [
  {
    "Sid": "VisualEditor0",
    "Effect": "Allow",
    "Action": [
      "s3:PutObject",
      "s3:GetObject",
      "s3:ListBucket",
      "s3:GetBucketLocation"
      ],
    "Resource": [
      "arn:aws:s3:::mlflow-test/*",
      "arn:aws:s3:::mlflow-test"
      ]
  }
  ]
}
}

Additionally, at least the \code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY}
environment variables must be set to the corresponding key and secrets provided
by Amazon IAM.
}
\keyword{internal}
