% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_xgboost.R
\name{LearnerXgboost}
\alias{LearnerXgboost}
\title{R6 Class to construct a Xgboost learner}
\description{
The \code{LearnerXgboost} class is the interface to the \code{xgboost} R package for
use with the \code{mlexperiments} package.
}
\details{
Optimization metric: needs to be specified with the learner parameter
\code{eval_metric}. The following options can be set via \code{options()}:
\itemize{
\item "mlexperiments.optim.xgb.nrounds" (default: \code{5000L})
\item "mlexperiments.optim.xgb.early_stopping_rounds" (default: \code{500L})
\item "mlexperiments.xgb.print_every_n" (default: \code{50L})
\item "mlexperiments.xgb.verbose" (default: \code{FALSE})
}

\code{LearnerXgboost} can be used with
\itemize{
\item \link[mlexperiments:MLTuneParameters]{mlexperiments::MLTuneParameters}
\item \link[mlexperiments:MLCrossValidation]{mlexperiments::MLCrossValidation}
\item \link[mlexperiments:MLNestedCV]{mlexperiments::MLNestedCV}
}
}
\examples{
# binary classification
Sys.setenv("OMP_THREAD_LIMIT" = 2)

library(mlbench)
data("PimaIndiansDiabetes2")
dataset <- PimaIndiansDiabetes2 |>
  data.table::as.data.table() |>
  na.omit()

seed <- 123
feature_cols <- colnames(dataset)[1:8]

param_list_xgboost <- expand.grid(
   subsample = seq(0.6, 1, .2),
   colsample_bytree = seq(0.6, 1, .2),
   min_child_weight = seq(1, 5, 4),
   learning_rate = seq(0.1, 0.2, 0.1),
   max_depth = seq(1, 5, 4),
   nthread = 2
)

train_x <- model.matrix(
  ~ -1 + .,
  dataset[, .SD, .SDcols = feature_cols]
)
train_y <- as.integer(dataset[, get("diabetes")]) - 1L

fold_list <- splitTools::create_folds(
  y = train_y,
  k = 3,
  type = "stratified",
  seed = seed
)
xgboost_cv <- mlexperiments::MLCrossValidation$new(
  learner = mllrnrs::LearnerXgboost$new(
    metric_optimization_higher_better = FALSE
  ),
  fold_list = fold_list,
  ncores = 2L,
  seed = 123
)
xgboost_cv$learner_args <- c(
  as.list(
    data.table::data.table(
      param_list_xgboost[37, ],
      stringsAsFactors = FALSE
    ),
  ),
  list(
    objective = "binary:logistic",
    eval_metric = "logloss"
  ),
  nrounds = 45L
)
xgboost_cv$performance_metric_args <- list(positive = "1")
xgboost_cv$performance_metric <- mlexperiments::metric("auc")

# set data
xgboost_cv$set_data(
  x = train_x,
  y = train_y
)

xgboost_cv$execute()


## ------------------------------------------------
## Method `LearnerXgboost$new`
## ------------------------------------------------

LearnerXgboost$new(metric_optimization_higher_better = FALSE)

}
\seealso{
\code{\link[xgboost:xgb.train]{xgboost::xgb.train()}}, \code{\link[xgboost:xgb.cv]{xgboost::xgb.cv()}}
}
\section{Super class}{
\code{\link[mlexperiments:MLLearnerBase]{mlexperiments::MLLearnerBase}} -> \code{LearnerXgboost}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerXgboost-new}{\code{LearnerXgboost$new()}}
\item \href{#method-LearnerXgboost-clone}{\code{LearnerXgboost$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="bayesian_scoring_function"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-bayesian_scoring_function'><code>mlexperiments::MLLearnerBase$bayesian_scoring_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="cross_validation"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-cross_validation'><code>mlexperiments::MLLearnerBase$cross_validation()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="fit"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-fit'><code>mlexperiments::MLLearnerBase$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlexperiments" data-topic="MLLearnerBase" data-id="predict"><a href='../../mlexperiments/html/MLLearnerBase.html#method-MLLearnerBase-predict'><code>mlexperiments::MLLearnerBase$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerXgboost-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerXgboost-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{LearnerXgboost} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerXgboost$new(metric_optimization_higher_better)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric_optimization_higher_better}}{A logical. Defines the direction
of the optimization metric used throughout the hyperparameter
optimization.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{LearnerXgboost} R6 object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{LearnerXgboost$new(metric_optimization_higher_better = FALSE)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerXgboost-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerXgboost-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerXgboost$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
