% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plausible_values.R
\name{plausible_values}
\alias{plausible_values}
\title{Plausible Values Range / Random Effect Confidence Intervals}
\usage{
plausible_values(x, pct = 95)
}
\arguments{
\item{x}{model produced using the \code{lme4::lmer()} function. This is an object of class \code{merMod} and subclass \code{lmerMod}.}

\item{pct}{Percentile for the plausible value range, similar to a confidence interval. Must be specified as a whole number between 1 and 100 (e.g., 99, 95, 80). The 95\% value range is used by default.}
}
\value{
A data frame specifying lower and upper bounds for each fixed effect.
}
\description{
The plausible values range is useful for gauging the magnitude of variation around fixed effects. For more information, see Raudenbush and Bryk (2002, p. 71) and Hoffman (2015, p. 166).
}
\examples{
fit <- lme4::lmer(mathach ~ 1 + ses + catholic + (1|id),
data=hsb, REML=TRUE)

plausible_values(fit) #default is 95\% range
plausible_values(fit, 99)

}
\references{
{
\insertRef{hoffman2015}{mlmhelpr}
}

{
\insertRef{raudenbush2002}{mlmhelpr}
}
}
