#'
#' @title BasicMotions
#' @description Multivariate time series (MTS) of four students performing four activities while wearing a smart watch.
#' @usage data(BasicMotions)
#' @format A \code{list} with two elements, which are:
#' \describe{
#' \item{\code{data}}{A list with 80 MTS.}
#' \item{\code{classes}}{A numeric vector indicating the corresponding classes associated with the elements in \code{data}.}
#' }
#' @details Each element in \code{data} is a matrix formed by 100 rows (time points) indicating movement and 6 columns (variables). The first 40 elements
#' correspond to the training set, whereas the last 40 elements correspond to the test set. The numeric vector \code{classes} is formed
#' by integers from 1 to 4, indicating that there are 4 different classes in the database. Each class is associated with a different
#' physical activity. For more information, \insertCite{bagnall2018uea;textual}{mlmts}.
#' @references{
#'
#'   \insertRef{bagnall2018uea}{mlmts}
#'
#'   \insertRef{ruiz2021great}{mlmts}
#'
#'   \insertRef{bagnallweb}{mlmts}
#'
#' }
"BasicMotions"

