% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WrappedModel.R
\name{makeWrappedModel}
\alias{makeWrappedModel}
\alias{WrappedModel}
\title{Induced model of learner.}
\usage{
makeWrappedModel(learner, learner.model, task.desc, subset, features,
  factor.levels, time)
}
\arguments{
\item{learner}{[\code{\link{Learner}} | \code{character(1)}]\cr
The learner.
If you pass a string the learner will be created via \code{\link{makeLearner}}.}

\item{learner.model}{[any]\cr
Underlying model.}

\item{task.desc}{[\code{\link{TaskDesc}}]\cr
Task description object.}

\item{subset}{[\code{integer}]\cr
Subset used for training.}

\item{features}{[\code{character}]\cr
Features used for training.}

\item{factor.levels}{[named \code{list} of \code{character}]\cr
Levels of factor variables (features and potentially target) in training data.
Named by variable name, non-factors do not occur in the list.}

\item{time}{[\code{numeric(1)}]\cr
Computation time for model fit in seconds.}
}
\value{
[\code{\link{WrappedModel}}].
}
\description{
Result from \code{\link{train}}.

It internally stores the underlying fitted model,
the subset used for training, features used for training, levels of factors in the
data set and computation time that was spent for training.

Object members: See arguments.

The constructor \code{makeWrappedModel} is mainly for internal use.
}
