% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureElapsedTime.R
\name{mlr_measures_elapsed_time}
\alias{mlr_measures_elapsed_time}
\alias{MeasureElapsedTime}
\alias{mlr_measures_time_train}
\alias{mlr_measures_time_predict}
\alias{mlr_measures_time_both}
\title{Elapsed Time Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \link{Measure}.}
\description{
Measures the elapsed time during train ("time_train"), predict ("time_predict"), or both ("time_both").
}
\section{Construction}{
\preformatted{MeasureElapsedTime$new(id, stages)

mlr_measures$get("time_train")
mlr_measures$get("time_predict")
mlr_measures$get("time_both")

msr$get("time_train")
msr$get("time_predict")
msr$get("time_both")
}
\itemize{
\item \code{id} :: \code{character(1)}\cr
Id for the created measure.
\item \code{stages} :: \code{character()}\cr
Subset of \verb{("train", "predict")}.
The runtime of all stages will be summed.
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{NA}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: 'response'
}
}

\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Measure]{Measures}: \link{mlr_measures}

\code{as.data.table(mlr_measures)} for a complete table of all (also dynamically created) \link{Measure} implementations.
}
