% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskGeneratorCircle.R
\name{mlr_task_generators_circle}
\alias{mlr_task_generators_circle}
\alias{TaskGeneratorCircle}
\title{Circle Classification Task Generator}
\description{
A \link{TaskGenerator} for the circle binary classification task in \code{\link[mlbench:mlbench.circle]{mlbench::mlbench.circle()}}.
Creates a large circle containing a smaller circle.
}
\section{Dictionary}{

This \link{TaskGenerator} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_task_generators} or with the associated sugar function \code{\link[=tgen]{tgen()}}:\preformatted{mlr_task_generators$get("circle")
tgen("circle")
}
}

\section{Parameters}{
\tabular{llll}{
   Id \tab Type \tab Default \tab Range \cr
   d \tab integer \tab 2 \tab \eqn{[2, \infty)}{[2, Inf)} \cr
}
}

\examples{
generator = tgen("circle")
plot(generator, n = 200)

task = generator$generate(200)
str(task$data())
}
\seealso{
\itemize{
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=TaskGenerator]{TaskGenerators}: \link{mlr_task_generators}
\item \code{as.data.table(mlr_task_generators)}  for a table of available \link[=TaskGenerator]{TaskGenerators} in the running session (depending on the loaded packages).
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
}

Other TaskGenerator: 
\code{\link{TaskGenerator}},
\code{\link{mlr_task_generators_2dnormals}},
\code{\link{mlr_task_generators_cassini}},
\code{\link{mlr_task_generators_friedman1}},
\code{\link{mlr_task_generators_moons}},
\code{\link{mlr_task_generators_simplex}},
\code{\link{mlr_task_generators_smiley}},
\code{\link{mlr_task_generators_spirals}},
\code{\link{mlr_task_generators_xor}},
\code{\link{mlr_task_generators}}
}
\concept{TaskGenerator}
\section{Super class}{
\code{\link[mlr3:TaskGenerator]{mlr3::TaskGenerator}} -> \code{TaskGeneratorCircle}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TaskGeneratorCircle$new()}}
\item \href{#method-plot}{\code{TaskGeneratorCircle$plot()}}
\item \href{#method-clone}{\code{TaskGeneratorCircle$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="format">}\href{../../mlr3/html/TaskGenerator.html#method-format}{\code{mlr3::TaskGenerator$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="generate">}\href{../../mlr3/html/TaskGenerator.html#method-generate}{\code{mlr3::TaskGenerator$generate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="TaskGenerator" data-id="print">}\href{../../mlr3/html/TaskGenerator.html#method-print}{\code{mlr3::TaskGenerator$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorCircle$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Creates a simple plot of generated data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorCircle$plot(n = 200L, pch = 19L, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{(\code{integer(1)})\cr
Number of samples to draw for the plot. Default is 200.}

\item{\code{pch}}{(\code{integer(1)})\cr
Point char. Passed to \code{\link[=plot]{plot()}}.}

\item{\code{...}}{(any)\cr
Additional arguments passed to \code{\link[=plot]{plot()}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskGeneratorCircle$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
