% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_prediction_clust.R
\name{as_prediction_clust}
\alias{as_prediction_clust}
\alias{as_prediction_clust.PredictionClust}
\alias{as_prediction_clust.data.frame}
\title{Convert to a Cluster Prediction}
\usage{
as_prediction_clust(x, ...)

\method{as_prediction_clust}{PredictionClust}(x, ...)

\method{as_prediction_clust}{data.frame}(x, ...)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{...}{(any)\cr
Additional arguments.}
}
\value{
\link{PredictionClust}.
}
\description{
Convert object to a \link{PredictionClust}.
}
\examples{
# create a prediction object
task = tsk("usarrests")
learner = lrn("clust.kmeans")
learner = lrn("clust.cmeans", predict_type = "prob")
learner$train(task)
p = learner$predict(task)

# convert to a data.table
tab = as.data.table(p)

# convert back to a Prediction
as_prediction_clust(tab)

# split data.table into a 3 data.tables based on UrbanPop
f = cut(task$data(rows = tab$row_ids)$UrbanPop, 3)
tabs = split(tab, f)

# convert back to list of predictions
preds = lapply(tabs, as_prediction_clust)

# calculate performance in each group
sapply(preds, function(p) p$score(task = task))
}
