% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/learner_fairml_regr_fairfrrm.R
\name{mlr_learners_regr.fairfrrm}
\alias{mlr_learners_regr.fairfrrm}
\alias{LearnerRegrFairfrrm}
\title{Regression Fair Ridge Regression Learner}
\description{
If more than one \code{pta} columns are provided, the hyperparameter \code{intersectional} controls whether
intersections of protected groups are formed (e.g. combinations of gender and race).
Initialized to \code{TRUE}.
If \code{FALSE}, only the group specified by the first element of \code{pta} is used.

Calls \link[fairml:frrm]{fairml::frrm} from package \CRANpkg{fairml}.
}
\details{
Fair ridge regression learner implemented via package \code{fairml}.
The 'unfairness' parameter has been initialized to 0.05.
}
\section{Dictionary}{
 This \link{Learner} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated
sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("regr.fairfrrm")
lrn("regr.fairfrrm")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}
\item Feature Types: \dQuote{integer}, \dQuote{numeric}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{fairml}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   lambda \tab numeric \tab 0 \tab  \tab \eqn{[0, \infty)}{[0, Inf)} \cr
   definition \tab character \tab sp-komiyama \tab sp-komiyama, eo-komiyama \tab - \cr
   save.auxiliary \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   unfairness \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
}
}

\examples{
# stop example failing with warning if package not installed
learner = suppressWarnings(mlr3::lrn("regr.fairfrrm"))
print(learner)

# available parameters:
learner$param_set$ids()
}
\references{
Scutari M, Panero F, Proissl M (2021).
\dQuote{Achieving Fairness with a Simple Ridge Penalty.}
\emph{arXiv preprint arXiv:2105.13817}.
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}:
\link[mlr3:mlr_learners]{mlr3::mlr_learners}

Other fairness_learners: 
\code{\link{mlr_learners_classif.fairfgrrm}},
\code{\link{mlr_learners_classif.fairzlrm}},
\code{\link{mlr_learners_regr.fairnclm}},
\code{\link{mlr_learners_regr.fairzlm}}
}
\author{
pfistfl
}
\concept{fairness_learners}
\keyword{internal}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrFairfrrm}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRegrFairfrrm-new}{\code{LearnerRegrFairfrrm$new()}}
\item \href{#method-LearnerRegrFairfrrm-clone}{\code{LearnerRegrFairfrrm$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrFairfrrm-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrFairfrrm-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFairfrrm$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrFairfrrm-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrFairfrrm-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrFairfrrm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
