% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_measures_fairness.R
\docType{data}
\name{mlr_measures_fairness}
\alias{mlr_measures_fairness}
\title{Fairness Measures in mlr3}
\format{
An object of class \code{data.table} (inherits from \code{data.frame}) with 18 rows and 2 columns.
}
\usage{
mlr_measures_fairness
}
\value{
A data.table containing an overview of available fairness metrics.
}
\description{
Fairness Measures in mlr3
}
\section{Predefined measures}{

\CRANpkg{mlr3fairness} comes with a set of predefined fairness measures as listed below.
For full flexibility, \link{MeasureFairness} can be used to construct classical
group fairness measures based on a difference between a performance metrics across groups
by combining a performance measure with an operation for measuring differences.
Furthermore \link{MeasureSubgroup} can be used to measure performance in a given subgroup, or alternatively
groupwise_metrics(measure, task) to instantiate a measure for each subgroup in a \link{Task}.

\tabular{ll}{
\strong{key} \tab \strong{description} \cr
fairness.acc         \tab Absolute differences in accuracy across groups                                                          \cr
fairness.mse         \tab Absolute differences in mean squared error across groups                                                \cr
fairness.fnr         \tab Absolute differences in false negative rates across groups                                              \cr
fairness.fpr         \tab Absolute differences in false positive rates across groups                                              \cr
fairness.tnr         \tab Absolute differences in true negative rates across groups                                               \cr
fairness.tpr         \tab Absolute differences in true positive rates across groups                                               \cr
fairness.npv         \tab Absolute differences in negative predictive values across groups                                        \cr
fairness.ppv         \tab Absolute differences in positive predictive values across groups                                        \cr
fairness.fomr        \tab Absolute differences in false omission rates across groups                                              \cr
fairness.fp          \tab Absolute differences in false positives across groups                                                   \cr
fairness.tp          \tab Absolute differences in true positives across groups                                                    \cr
fairness.tn          \tab Absolute differences in true negatives across groups                                                    \cr
fairness.fn          \tab Absolute differences in false negatives across groups                                                   \cr
fairness.cv          \tab Difference in positive class prediction, also known as Calders-Wevers gap or demographic parity         \cr
fairness.eod         \tab Equalized Odds: Sum of absolute differences between true positive and false positive rates across groups\cr
fairness.pp          \tab Predictive Parity: Sum of absolute differences between ppv and npv across groups                        \cr
fairness.acc_eod=.05 \tab Accuracy under equalized odds < 0.05 constraint                                                         \cr
fairness.acc_ppv=.05 \tab Accuracy under ppv difference < 0.05 constraint
}
}

\examples{
# Predefined measures:
mlr_measures_fairness$key
}
\keyword{datasets}
