% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterInformationGain.R
\docType{data}
\name{FilterInformationGain}
\alias{FilterInformationGain}
\alias{mlr_filters_information_gain}
\title{Information Gain Filter}
\format{\link[R6:R6Class]{R6::R6Class} inheriting from \link{Filter}.}
\description{
Information gain filter calling
\code{\link[FSelectorRcpp:information_gain]{FSelectorRcpp::information_gain()}} in package \CRANpkg{FSelectorRcpp}. Set
parameter \code{"type"} to \code{"gainratio"} to calculate the gain ratio, or set to
\code{"symuncert"} to calculate the symmetrical uncertainty (see
\code{\link[FSelectorRcpp:information_gain]{FSelectorRcpp::information_gain()}}). Default is \code{"infogain"}.

Argument \code{equal} defaults to \code{FALSE} for classification tasks, and to
\code{TRUE} for regression tasks.
}
\section{Construction}{
\preformatted{FilterInformationGain$new()
mlr_filters$get("information_gain")
flt("information_gain")
}
}

\examples{
## InfoGain (default)
task = mlr3::tsk("pima")
filter = flt("information_gain")
filter$calculate(task)
head(filter$scores, 3)
as.data.table(filter)

## GainRatio

filterGR = flt("information_gain")
filterGR$param_set$values = list("type" = "gainratio")
filterGR$calculate(task)
head(as.data.table(filterGR), 3)

}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}

Other Filter: \code{\link{FilterAUC}},
  \code{\link{FilterAnova}}, \code{\link{FilterCMIM}},
  \code{\link{FilterCarScore}},
  \code{\link{FilterCorrelation}},
  \code{\link{FilterDISR}}, \code{\link{FilterImportance}},
  \code{\link{FilterJMIM}}, \code{\link{FilterJMI}},
  \code{\link{FilterKruskalTest}}, \code{\link{FilterMIM}},
  \code{\link{FilterMRMR}}, \code{\link{FilterNJMIM}},
  \code{\link{FilterPerformance}},
  \code{\link{FilterVariance}}, \code{\link{Filter}},
  \code{\link{mlr_filters}}
}
\concept{Filter}
\keyword{datasets}
