% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterFindCorrelation.R
\name{mlr_filters_find_correlation}
\alias{mlr_filters_find_correlation}
\alias{FilterFindCorrelation}
\title{Correlation Filter}
\description{
Simple filter emulating \code{caret::findCorrelation(exact = FALSE)}.

This gives each feature a score between 0 and 1 that is \emph{one minus} the
cutoff value for which it is excluded when using \code{\link[caret:findCorrelation]{caret::findCorrelation()}}.
The negative is used because \code{\link[caret:findCorrelation]{caret::findCorrelation()}} excludes everything
\emph{above} a cutoff, while filters exclude everything below a cutoff.
Here the filter scores are shifted by +1 to get positive values for to align
with the way other filters work.

Subsequently \code{caret::findCorrelation(cutoff = 0.9)} lists the same features
that are excluded with \code{FilterFindCorrelation} at score 0.1 (= 1 - 0.9).
}
\examples{
# Pearson (default)
task = mlr3::tsk("mtcars")
filter = flt("find_correlation")
filter$calculate(task)
as.data.table(filter)

## Spearman
filter = flt("find_correlation", method = "spearman")
filter$calculate(task)
as.data.table(filter)

if (mlr3misc::require_namespaces(c("mlr3pipelines", "rpart"), quietly = TRUE)) {
  library("mlr3pipelines")
  task = mlr3::tsk("spam")

  # Note: `filter.frac` is selected randomly and should be tuned.

  graph = po("filter", filter = flt("find_correlation"), filter.frac = 0.5) \%>>\%
    po("learner", mlr3::lrn("classif.rpart"))

  graph$train(task)
}
}
\seealso{
\itemize{
\item \link[mlr3pipelines:mlr_pipeops_filter]{PipeOpFilter} for filter-based feature selection.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Filter]{Filters}: \link{mlr_filters}
}

Other Filter: 
\code{\link{Filter}},
\code{\link{mlr_filters_anova}},
\code{\link{mlr_filters_auc}},
\code{\link{mlr_filters_carscore}},
\code{\link{mlr_filters_carsurvscore}},
\code{\link{mlr_filters_cmim}},
\code{\link{mlr_filters_correlation}},
\code{\link{mlr_filters_disr}},
\code{\link{mlr_filters_importance}},
\code{\link{mlr_filters_information_gain}},
\code{\link{mlr_filters_jmim}},
\code{\link{mlr_filters_jmi}},
\code{\link{mlr_filters_kruskal_test}},
\code{\link{mlr_filters_mim}},
\code{\link{mlr_filters_mrmr}},
\code{\link{mlr_filters_njmim}},
\code{\link{mlr_filters_performance}},
\code{\link{mlr_filters_permutation}},
\code{\link{mlr_filters_relief}},
\code{\link{mlr_filters_selected_features}},
\code{\link{mlr_filters_variance}},
\code{\link{mlr_filters}}
}
\concept{Filter}
\section{Super class}{
\code{\link[mlr3filters:Filter]{mlr3filters::Filter}} -> \code{FilterFindCorrelation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FilterFindCorrelation-new}{\code{FilterFindCorrelation$new()}}
\item \href{#method-FilterFindCorrelation-clone}{\code{FilterFindCorrelation$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="calculate"><a href='../../mlr3filters/html/Filter.html#method-Filter-calculate'><code>mlr3filters::Filter$calculate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="format"><a href='../../mlr3filters/html/Filter.html#method-Filter-format'><code>mlr3filters::Filter$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="help"><a href='../../mlr3filters/html/Filter.html#method-Filter-help'><code>mlr3filters::Filter$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3filters" data-topic="Filter" data-id="print"><a href='../../mlr3filters/html/Filter.html#method-Filter-print'><code>mlr3filters::Filter$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterFindCorrelation-new"></a>}}
\if{latex}{\out{\hypertarget{method-FilterFindCorrelation-new}{}}}
\subsection{Method \code{new()}}{
Create a FilterFindCorrelation object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterFindCorrelation$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FilterFindCorrelation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FilterFindCorrelation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FilterFindCorrelation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
