% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrXgboost.R
\name{mlr_learners_regr.xgboost}
\alias{mlr_learners_regr.xgboost}
\alias{LearnerRegrXgboost}
\title{Extreme Gradient Boosting Regression Learner}
\description{
eXtreme Gradient Boosting regression.
Calls \code{\link[xgboost:xgb.train]{xgboost::xgb.train()}} from package \CRANpkg{xgboost}.

To compute on GPUs, you first need to compile \CRANpkg{xgboost} yourself and link
against CUDA. See \url{https://xgboost.readthedocs.io/en/stable/build.html#building-with-gpu-support}.
}
\note{
To compute on GPUs, you first need to compile \CRANpkg{xgboost} yourself and link
against CUDA.
See \url{https://xgboost.readthedocs.io/en/stable/build.html#building-with-gpu-support}.
}
\section{Dictionary}{

This \link{Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_learners} or with the associated sugar function \code{\link[=lrn]{lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("regr.xgboost")
lrn("regr.xgboost")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

, * Task type: \dQuote{regr}, * Predict Types: \dQuote{response}, * Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, * Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{xgboost}
}

\section{Parameters}{

, |Id                          |Type      |Default          |Levels                                   |Range                                |, |:---------------------------|:---------|:----------------|:----------------------------------------|:------------------------------------|, |alpha                       |numeric   |0                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |approxcontrib               |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |base_score                  |numeric   |0.5              |                                         |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |booster                     |character |gbtree           |gbtree, gblinear, dart                   |-                                    |, |callbacks                   |untyped   |list             |                                         |-                                    |, |colsample_bylevel           |numeric   |1                |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |colsample_bynode            |numeric   |1                |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |colsample_bytree            |numeric   |1                |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |disable_default_eval_metric |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |early_stopping_rounds       |integer   |NULL             |                                         |\eqn{[1, \infty)}{[1, Inf)}          |, |eta                         |numeric   |0.3              |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |eval_metric                 |untyped   |rmse             |                                         |-                                    |, |feature_selector            |character |cyclic           |cyclic, shuffle, random, greedy, thrifty |-                                    |, |feval                       |untyped   |                 |                                         |-                                    |, |gamma                       |numeric   |0                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |grow_policy                 |character |depthwise        |depthwise, lossguide                     |-                                    |, |interaction_constraints     |untyped   |-                |                                         |-                                    |, |iterationrange              |untyped   |-                |                                         |-                                    |, |lambda                      |numeric   |1                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |lambda_bias                 |numeric   |0                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |max_bin                     |integer   |256              |                                         |\eqn{[2, \infty)}{[2, Inf)}          |, |max_delta_step              |numeric   |0                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |max_depth                   |integer   |6                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |max_leaves                  |integer   |0                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |maximize                    |logical   |NULL             |TRUE, FALSE                              |-                                    |, |min_child_weight            |numeric   |1                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |missing                     |numeric   |NA               |                                         |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |monotone_constraints        |untyped   |0                |                                         |-                                    |, |normalize_type              |character |tree             |tree, forest                             |-                                    |, |nrounds                     |integer   |-                |                                         |\eqn{[1, \infty)}{[1, Inf)}          |, |nthread                     |integer   |1                |                                         |\eqn{[1, \infty)}{[1, Inf)}          |, |ntreelimit                  |integer   |NULL             |                                         |\eqn{[1, \infty)}{[1, Inf)}          |, |num_parallel_tree           |integer   |1                |                                         |\eqn{[1, \infty)}{[1, Inf)}          |, |objective                   |untyped   |reg:squarederror |                                         |-                                    |, |one_drop                    |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |outputmargin                |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |predcontrib                 |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |predictor                   |character |cpu_predictor    |cpu_predictor, gpu_predictor             |-                                    |, |predinteraction             |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |predleaf                    |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |print_every_n               |integer   |1                |                                         |\eqn{[1, \infty)}{[1, Inf)}          |, |process_type                |character |default          |default, update                          |-                                    |, |rate_drop                   |numeric   |0                |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |refresh_leaf                |logical   |TRUE             |TRUE, FALSE                              |-                                    |, |reshape                     |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |sampling_method             |character |uniform          |uniform, gradient_based                  |-                                    |, |sample_type                 |character |uniform          |uniform, weighted                        |-                                    |, |save_name                   |untyped   |                 |                                         |-                                    |, |save_period                 |integer   |NULL             |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |scale_pos_weight            |numeric   |1                |                                         |\eqn{(-\infty, \infty)}{(-Inf, Inf)} |, |seed_per_iteration          |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |sketch_eps                  |numeric   |0.03             |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |skip_drop                   |numeric   |0                |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |strict_shape                |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |subsample                   |numeric   |1                |                                         |\eqn{[0, 1]}{[0, 1]}                 |, |top_k                       |integer   |0                |                                         |\eqn{[0, \infty)}{[0, Inf)}          |, |training                    |logical   |FALSE            |TRUE, FALSE                              |-                                    |, |tree_method                 |character |auto             |auto, exact, approx, hist, gpu_hist      |-                                    |, |tweedie_variance_power      |numeric   |1.5              |                                         |\eqn{[1, 2]}{[1, 2]}                 |, |updater                     |untyped   |-                |                                         |-                                    |, |verbose                     |integer   |1                |                                         |\eqn{[0, 2]}{[0, 2]}                 |, |watchlist                   |untyped   |                 |                                         |-                                    |, |xgb_model                   |untyped   |                 |                                         |-                                    |
}

\section{Custom mlr3 defaults}{

\itemize{
\item \code{nrounds}:
\itemize{
\item Actual default: no default.
\item Adjusted default: 1.
\item Reason for change: Without a default construction of the learner
would error. Just setting a nonsense default to workaround this.
\code{nrounds} needs to be tuned by the user.
}
\item \code{nthread}:
\itemize{
\item Actual value: Undefined, triggering auto-detection of the number of CPUs.
\item Adjusted value: 1.
\item Reason for change: Conflicting with parallelization via \CRANpkg{future}.
}
\item \code{verbose}:
\itemize{
\item Actual default: 1.
\item Adjusted default: 0.
\item Reason for change: Reduce verbosity.
}
}
}

\examples{
if (requireNamespace("xgboost", quietly = TRUE)) {
  learner = mlr3::lrn("regr.xgboost")
  print(learner)

  # available parameters:
learner$param_set$ids()
}
}
\references{
Chen, Tianqi, Guestrin, Carlos (2016).
\dQuote{Xgboost: A scalable tree boosting system.}
In \emph{Proceedings of the 22nd ACM SIGKDD Conference on Knowledge Discovery and Data Mining}, 785--794.
ACM.
\doi{10.1145/2939672.2939785}.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/basics.html#learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[=Learner]{Learners}: \link{mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[=Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.ranger}},
\code{\link{mlr_learners_regr.svm}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrXgboost}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRegrXgboost-new}{\code{LearnerRegrXgboost$new()}}
\item \href{#method-LearnerRegrXgboost-importance}{\code{LearnerRegrXgboost$importance()}}
\item \href{#method-LearnerRegrXgboost-clone}{\code{LearnerRegrXgboost$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrXgboost-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrXgboost-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrXgboost$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrXgboost-importance"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrXgboost-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are calculated with \code{\link[xgboost:xgb.importance]{xgboost::xgb.importance()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrXgboost$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrXgboost-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrXgboost-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrXgboost$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
