% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_namespace_callback.R
\name{register_namespace_callback}
\alias{register_namespace_callback}
\title{Registers a Callback on Namespace load/unLoad Events}
\usage{
register_namespace_callback(pkgname, namespace, callback)
}
\arguments{
\item{pkgname}{(\code{character(1)})\cr
Name of the package which registers the callback.}

\item{namespace}{(\code{character(1)})\cr
Namespace to react on.}

\item{callback}{(\verb{function()})\cr
Function to call on namespace load.}
}
\value{
\code{NULL}.
}
\description{
Register a function \code{callback} to be called after a namespace is loaded.
Calls \code{callback} once if the namespace has already been loaded before and
also adds an unload-hook that removes the load hook.
}
