% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_oml_data.R, R/list_oml_evaluations.R,
%   R/list_oml_flows.R, R/list_oml_measures.R, R/list_oml_runs.R,
%   R/list_oml_setups.R, R/list_oml_tasks.R
\name{list_oml}
\alias{list_oml}
\alias{list_oml_data}
\alias{list_oml_evaluations}
\alias{list_oml_flows}
\alias{list_oml_measures}
\alias{list_oml_runs}
\alias{list_oml_setups}
\alias{list_oml_tasks}
\title{List Data from OpenML}
\usage{
list_oml_data(
  data_id = NULL,
  data_name = NULL,
  number_instances = NULL,
  number_features = NULL,
  number_classes = NULL,
  number_missing_values = NULL,
  tag = NULL,
  limit = limit_default(),
  test_server = test_server_default(),
  ...
)

list_oml_evaluations(
  run_id = NULL,
  task_id = NULL,
  measures = NULL,
  tag = NULL,
  limit = limit_default(),
  test_server = test_server_default(),
  ...
)

list_oml_flows(
  uploader = NULL,
  tag = NULL,
  limit = limit_default(),
  test_server = test_server_default(),
  ...
)

list_oml_measures(test_server = test_server_default())

list_oml_runs(
  run_id = NULL,
  task_id = NULL,
  tag = NULL,
  flow_id = NULL,
  limit = limit_default(),
  test_server = test_server_default(),
  ...
)

list_oml_setups(
  flow_id = NULL,
  setup_id = NULL,
  tag = NULL,
  limit = limit_default(),
  test_server = test_server_default(),
  ...
)

list_oml_tasks(
  task_id = NULL,
  data_id = NULL,
  number_instances = NULL,
  number_features = NULL,
  number_classes = NULL,
  number_missing_values = NULL,
  tag = NULL,
  limit = limit_default(),
  test_server = test_server_default(),
  type = NULL,
  ...
)
}
\arguments{
\item{data_id}{(\code{integer()})\cr
Vector of data ids to restrict to.}

\item{data_name}{(\code{character(1)})\cr
Filter for name of data set.}

\item{number_instances}{(\code{integer()})\cr
Filter for number of instances.}

\item{number_features}{(\code{integer()})\cr
Filter for number of features.}

\item{number_classes}{(\code{integer()})\cr
Filter for number of labels of the target (only classification tasks).}

\item{number_missing_values}{(\code{integer()})\cr
Filter for number of missing values.}

\item{tag}{(\code{character()})\cr
Filter for tags. You can provide multiple tags as character vector.}

\item{limit}{(\code{integer()})\cr
Limit the results to \code{limit} records.
Default is the value of option \code{"mlr3oml.limit"}, defaulting to 5000.}

\item{test_server}{(\code{character(1)})\cr
Whether to use the OpenML test server or public server.
Defaults to value of option \code{"mlr3oml.test_server"}, or \code{FALSE} if not set.}

\item{...}{(any)\cr
Additional (unsupported) filters, as named arguments.}

\item{run_id}{(\code{integer()})\cr
Vector of run ids to restrict to.}

\item{task_id}{(\code{integer()})\cr
Vector of task ids to restrict to.}

\item{measures}{(\code{character()})\cr
Vector of evaluation measures to restrict to.}

\item{uploader}{(\code{integer(1)})\cr
Filter for uploader.}

\item{flow_id}{(\code{integer(1)})\cr
Filter for flow id.}

\item{setup_id}{(\code{integer()})\cr
Vector of setup ids to restrict to.}

\item{type}{(\code{character(1)})\cr
The task type, supported values are: \code{"clasisf"}, \code{"regr"}, \code{"surv"} and \code{"clust"}.}
}
\value{
(\code{data.table()}) of results, or a null data.table if no data set matches the filter criteria.
}
\description{
This function allows to query data sets, tasks, flows, setups, runs, and evaluation measures
from \url{https://www.openml.org/search?type=data&sort=runs&status=active} using some simple filter criteria.

To find datasets for a specific task type, use \code{\link[=list_oml_tasks]{list_oml_tasks()}} which supports filtering according to the task
type.
Another heuristic to search for possible regression tasks is to search for data sets with
0 number of classes, i.e. by specifying \code{number_classes = 0}.
}
\details{
Filter values are usually provided as single atomic values (typically integer or character).
Provide a numeric vector of length 2 (\code{c(l, u)}) to find matches in the range \eqn{[l, u]}.

Note that only a subset of filters is exposed here.
For a more feature-complete package, see \CRANpkg{OpenML}.
Alternatively, you can pass additional filters via \code{...} using the names of the official API,
c.f. the \emph{REST} tab of \url{https://www.openml.org/apis}.
}
\examples{
# For technical reasons, examples cannot be included in this R package.
# Instead, these are some relevant resources:
#
# Large-Scale Benchmarking chapter in the mlr3book:
# https://mlr3book.mlr-org.com/chapters/chapter11/large-scale_benchmarking.html
#
# Package Article:
# https://mlr3oml.mlr-org.com/articles/tutorial.html
}
\references{
Casalicchio G, Bossek J, Lang M, Kirchhoff D, Kerschke P, Hofner B, Seibold H, Vanschoren J, Bischl B (2017).
\dQuote{OpenML: An R Package to Connect to the Machine Learning Platform OpenML.}
\emph{Computational Statistics}, 1--15.
\doi{10.1007/s00180-017-0742-2}.

Vanschoren J, van Rijn JN, Bischl B, Torgo L (2014).
\dQuote{OpenML.}
\emph{ACM SIGKDD Explorations Newsletter}, \bold{15}(2), 49--60.
\doi{10.1145/2641190.2641198}.
}
