% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpUnbranch.R
\name{mlr_pipeops_unbranch}
\alias{mlr_pipeops_unbranch}
\alias{PipeOpUnbranch}
\title{PipeOpUnbranch}
\format{\code{\link{R6Class}} object inheriting from \code{\link{PipeOp}}.}
\description{
Used to bring together different paths created by \code{\link{PipeOpBranch}}.
}
\section{Construction}{
\preformatted{PipeOpUnbranch$new(options, id = "unbranch", param_vals = list())
}
\itemize{
\item \code{options} :: \code{numeric(1)} | \code{character}\cr
If \code{options} is 0, a vararg input channel is created that can take
any number of inputs.
If \code{options} is a nonzero integer number, it determines the number of
input channels / options that are created, named \code{input1}...\verb{input<n>}. The
If \code{options} is a \code{character}, it determines the names of channels directly.
The difference between these three is purely cosmetic if the user chooses
to produce channel names matching with the corresponding \code{\link{PipeOpBranch}}.
However, it is not necessary to have matching names and the \emph{vararg} option
is always viable.
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"unbranch"}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output}{

\code{\link{PipeOpUnbranch}} has multiple input channels depending on the \code{options} construction argument, named \code{"input1"}, \code{"input2"}, ...
if \code{options} is a nonzero integer and named after each \code{options} value if \code{options} is a \code{character}; if \code{options} is 0, there is only one
\emph{vararg} input channel named \code{"..."}.
All input channels take any argument (\code{"*"}) both during training and prediction.

\code{\link{PipeOpUnbranch}} has one output channel named \code{"output"}, producing the only \code{\link{NO_OP}} object received as input (\code{"*"}),
both during training and prediction.
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

\code{\link{PipeOpUnbranch}} has no parameters.
}

\section{Internals}{

See \code{\link{PipeOpBranch}} Internals on how alternative path branching works.
}

\section{Fields}{

Only fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
# See PipeOpBranch for a complete branching example
pou = po("unbranch")

pou$train(list(NO_OP, NO_OP, "hello", NO_OP, NO_OP))
}
\seealso{
Other PipeOps: 
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOp}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputenewlvl}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_yeojohnson}},
\code{\link{mlr_pipeops}}

Other Path Branching: 
\code{\link{NO_OP}},
\code{\link{filter_noop}()},
\code{\link{is_noop}()},
\code{\link{mlr_pipeops_branch}}
}
\concept{Path Branching}
\concept{PipeOps}
