% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpLearnerQuantiles.R
\name{mlr_pipeops_learner_quantiles}
\alias{mlr_pipeops_learner_quantiles}
\alias{PipeOpLearnerQuantiles}
\title{Wrap a Learner into a PipeOp to predict multiple Quantiles}
\format{
\code{\link[R6:R6Class]{R6Class}} object inheriting from \code{\link{PipeOp}}.
}
\description{
Wraps a \code{\link[mlr3:LearnerRegr]{LearnerRegr}} into a \code{\link{PipeOp}} to predict multiple quantiles.

\code{PipeOpLearnerQuantiles} only supports \code{\link[mlr3:LearnerRegr]{LearnerRegr}}s that have \code{quantiles} as a possible \code{pedict_type}.

It produces quantile-based predictions for multiple quantiles in one \code{\link[mlr3:Prediction]{PredictionRegr}}. This is especially helpful if the \code{\link[mlr3:LearnerRegr]{LearnerRegr}} can only predict one quantile (like for example \code{LearnerRegrGBM} in \code{mlr3extralearners})

Inherits the \verb{$param_set} (and therefore \verb{$param_set$values}) from the \code{\link[mlr3:Learner]{Learner}} it is constructed from.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpLearnerQuantiles$new(learner, id = NULL, param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{learner} :: \code{\link[mlr3:Learner]{Learner}} | \code{character(1)}\cr
\code{\link[mlr3:Learner]{Learner}} to wrap, or a string identifying a \code{\link[mlr3:Learner]{Learner}} in the \code{\link[mlr3:mlr_learners]{mlr3::mlr_learners}} \code{\link[mlr3misc:Dictionary]{Dictionary}}.
The \code{\link[mlr3:Learner]{Learner}} has to be a \code{\link[mlr3:LearnerRegr]{LearnerRegr}} with \code{predict_type} \code{"quantiles"}.
This argument is always cloned; to access the \code{\link[mlr3:Learner]{Learner}} inside \code{PipeOpLearnerQuantiles} by-reference, use \verb{$learner}.
\item \code{id} :: \code{character(1)}
Identifier of the resulting  object, internally defaulting to the \code{id} of the \code{\link[mlr3:Learner]{Learner}} being wrapped.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{PipeOpLearnerQuantiles} has one input channel named \code{"input"}, taking a \code{\link[mlr3:TaskRegr]{TaskRegr}} specific to the \code{\link[mlr3:Learner]{Learner}}
type given to \code{learner} during construction; both during training and prediction.

\code{PipeOpLearnerQuantiles} has one output channel named \code{"output"}, producing \code{NULL} during training and a \code{\link[mlr3:Prediction]{PredictionRegr}} object
during prediction.

The output during prediction is a \code{\link[mlr3:PredictionRegr]{PredictionRegr}} on the prediction input data that aggregates all \code{result}s produced by the \code{\link[mlr3:Learner]{Learner}} for each quantile in \code{quantiles}.
trained on the training input data.
}

\section{State}{

The \verb{$state} is set during training. It is a named \code{list} with the member:
\itemize{
\item \code{model_states} :: \code{list}\cr
List of the states of all models created by the \code{\link[mlr3:Learner]{Learner}}'s \verb{$.train()} function.
}
}

\section{Parameters}{

The parameters are exactly the parameters of the \code{\link[mlr3:Learner]{Learner}} wrapped by this object.
\itemize{
\item \code{q_vals} :: \code{numeric}\cr
Quantiles to use for training and prediction.
Initialized to \code{c(0.05, 0.5, 0.95)}
\item \code{q_response} :: \code{numeric(1)}\cr
Which quantile in \code{quantiles} to use as a \code{response} for the \code{\link[mlr3:PredictionRegr]{PredictionRegr}} during prediction.
Initialized to \code{0.5}.
}
}

\section{Internals}{

The \verb{$state} is updated during training.
}

\section{Fields}{

Fields inherited from \code{\link{PipeOp}}, as well as:
\itemize{
\item \code{learner} :: \code{\link[mlr3:LearnerRegr]{LearnerRegr}}\cr
\code{\link[mlr3:Learner]{Learner}} that is being wrapped. Read-only.
\item \code{learner_model} :: \code{\link[mlr3:Learner]{Learner}}\cr
If \code{PipeOpLearnerQuantiles} has been trained, this is a \code{list} containing the \code{\link[mlr3:Learner]{Learner}}s for each quantile.
Otherwise, this contains the \code{\link[mlr3:Learner]{Learner}} that is being wrapped.
Read-only.
\item \code{predict_type} :: \code{character(1)}\cr
Predict type of the \code{PipeOpLearnerQuantiles}, which is always \verb{"response"  "quantiles"}.
}
}

\section{Methods}{

Methods inherited from \code{\link{PipeOp}}.
}

\examples{
library("mlr3")

task = tsk("boston_housing")
learner = lrn("regr.debug")
po = mlr_pipeops$get("learner_quantiles", learner)

po$train(list(task))
po$predict(list(task))
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEncodePL}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_adas}},
\code{\link{mlr_pipeops_blsmote}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_decode}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_encodeplquantiles}},
\code{\link{mlr_pipeops_encodepltree}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_info}},
\code{\link{mlr_pipeops_isomap}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_pi_cvplus}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nearmiss}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_proxy}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_rowapply}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_smotenc}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tomek}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}

Other Meta PipeOps: 
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_learner_cv}},
\code{\link{mlr_pipeops_learner_pi_cvplus}}
}
\concept{Meta PipeOps}
\concept{PipeOps}
