% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_convert_types.R
\name{mlr_graphs_convert_types}
\alias{mlr_graphs_convert_types}
\alias{pipeline_convert_types}
\title{Convert Column Types}
\usage{
pipeline_convert_types(
  type_from,
  type_to,
  affect_columns = NULL,
  id = NULL,
  fixfactors = NULL,
  more_args = list()
)
}
\arguments{
\item{type_from}{\code{character} \cr
Which column types to convert. May be any combination of \code{"logical"}, \code{"integer"}, \code{"numeric"}, \code{"factor"}, \code{"ordered"}, \code{"character"}, or \code{"POSIXct"}.}

\item{type_to}{\code{character(1)} \cr
Which type to convert to. Must be a scalar value, exactly one of the types allowed in \code{type_from}.}

\item{affect_columns}{\code{function} | \code{\link{Selector}} | \code{NULL} \cr
Which columns to affect. This argument can further restrict the columns being converted, beyond the \code{type_from} argument.
Must be a \code{\link{Selector}}-like function, which takes a \code{\link[mlr3:Task]{Task}} as argument and returns a \code{character} of features to use.}

\item{id}{\code{character(1)} | \code{NULL} \cr
ID to give to the constructed \code{\link{PipeOp}}s.
Defaults to an ID built automatically from \code{type_from} and \code{type_to}.
If a \code{\link{PipeOpFixFactors}} is appended, its ID will be \code{paste0(id, "_ff")}.}

\item{fixfactors}{\code{logical(1)} | \code{NULL} \cr
Whether to append a \code{\link{PipeOpFixFactors}}. Defaults to \code{TRUE} if and only if \code{type_to} is \code{"factor"} or \code{"ordered"}.}

\item{more_args}{\code{list} \cr
Additional arguments to give to the conversion function. This could e.g. be used to pass the timezone to \code{as.POSIXct}.}
}
\value{
\code{\link{Graph}}
}
\description{
Converts all columns of type \code{type_from} to \code{type_to}, using the corresponding R function (e.g. \code{as.numeric()}, \code{as.factor()}).
It is possible to further subset the columns that should be affected using the \code{affect_columns} argument.
The resulting \code{\link{Graph}} contains a \code{\link{PipeOpColApply}}, followed, if appropriate, by a \code{\link{PipeOpFixFactors}}.

Unlike R's \code{as.factor()} function, \code{ppl("convert_types")} will convert \code{ordered} types into (unordered) \code{factor} vectors.
}
\examples{
library("mlr3")

data_chr = data.table::data.table(
  x = factor(letters[1:3]),
  y = letters[1:3],
  z = letters[1:3]
)
task_chr = TaskClassif$new("task_chr", data_chr, "x")
str(task_chr$data())

graph = ppl("convert_types", "character", "factor")
str(graph$train(task_chr)[[1]]$data())

graph_z = ppl("convert_types", "character", "factor",
  affect_columns = selector_name("z"))
graph_z$train(task_chr)[[1]]$data()

# `affect_columns` and `type_from` are both applied. The following
# looks for a 'numeric' column with name 'z', which is not present;
# the task is therefore unchanged.
graph_z = ppl("convert_types", "numeric", "factor",
  affect_columns = selector_name("z"))
graph_z$train(task_chr)[[1]]$data()
}
