% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureSurvChamblessAUC.R
\name{MeasureSurvChamblessAUC}
\alias{MeasureSurvChamblessAUC}
\alias{mlr_measures_surv.chamblessAUC}
\title{Chambless and Diao's AUC Survival Measure}
\format{\code{\link[R6:R6Class]{R6::R6Class()}} inheriting from \code{MeasureSurvAUC}/\link{MeasureSurv}.}
\description{


Calls \code{\link[survAUC:AUC.cd]{survAUC::AUC.cd()}}.

Assumes Cox PH model specification.
}
\details{
All measures implemented from \CRANpkg{survAUC} should be used with care, we are aware
of problems in implementation that sometimes cause fatal errors in R. In future updates these
measures will all be re-written and implemented directly in \code{mlr3proba}.
}
\section{Construction}{
\preformatted{MeasureSurvChamblessAUC$new(integrated = TRUE, times)
mlr_measures$get("surv.chamblessAUC")
msr("surv.chamblessAUC")
}
\itemize{
\item \code{integrated} :: \code{logical(1)} \cr If \code{TRUE} (default), returns the integrated score; otherwise, not integrated. \cr
\item \code{times} :: \code{vector()} \cr If \code{integrate == TRUE} then a vector of time-points over which to integrate the score. If \code{integrate == FALSE} then a single time point at which to return the score. \cr
}
}

\section{Meta Information}{

\itemize{
\item Type: \code{"surv"}
\item Range: \eqn{[0, 1]}{[0, 1]}
\item Minimize: \code{FALSE}
\item Required prediction: \code{lp}
}
}

\section{Fields}{

See \link{MeasureSurv}, as well as all variables passed to the constructor.
}

\references{
\cite{mlr3proba}{chambless_2006}
}
\seealso{
Other survival measures: 
\code{\link{MeasureSurvBeggC}},
\code{\link{MeasureSurvGonenC}},
\code{\link{MeasureSurvGrafSE}},
\code{\link{MeasureSurvGraf}},
\code{\link{MeasureSurvHarrellC}},
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvIntLoglossSE}},
\code{\link{MeasureSurvIntLogloss}},
\code{\link{MeasureSurvLoglossSE}},
\code{\link{MeasureSurvLogloss}},
\code{\link{MeasureSurvNagelkR2}},
\code{\link{MeasureSurvOQuigleyR2}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}},
\code{\link{MeasureSurvXuR2}}

Other AUC survival measures: 
\code{\link{MeasureSurvHungAUC}},
\code{\link{MeasureSurvSongAUC}},
\code{\link{MeasureSurvSongTNR}},
\code{\link{MeasureSurvSongTPR}},
\code{\link{MeasureSurvUnoAUC}},
\code{\link{MeasureSurvUnoTNR}},
\code{\link{MeasureSurvUnoTPR}}
}
\concept{AUC survival measures}
\concept{survival measures}
