% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pecs.R
\name{pecs}
\alias{pecs}
\alias{pecs.list}
\alias{pecs.PredictionSurv}
\title{Prediction Error Curves for PredictionSurv and LearnerSurv}
\usage{
pecs(x, measure = c("graf", "logloss"), times, n, eps = 1e-15, ...)

\method{pecs}{list}(
  x,
  measure = c("graf", "logloss"),
  times,
  n,
  eps = 1e-15,
  task = NULL,
  row_ids = NULL,
  newdata,
  ...
)

\method{pecs}{PredictionSurv}(x, measure = c("graf", "logloss"), times, n, eps = 1e-15, ...)
}
\arguments{
\item{x}{(\link{PredictionSurv} or \code{list} of \link{LearnerSurv}s)}

\item{measure}{(\code{character(1)}) \cr
Either \code{"graf"} for \link{MeasureSurvGraf}, or \code{"logloss"} for \link{MeasureSurvIntLogloss}}

\item{times}{(\code{numeric()}) \cr
If provided then either a vector of time-points to evaluate \code{measure} or a range of
time-points.}

\item{n}{(\code{integer()}) \cr
If \code{times} is missing or given as a range, then \code{n} provide number of time-points to evaluate
\code{measure} over.}

\item{eps}{(\code{numeric()}) \cr
Small error value to pass to \link{MeasureSurvIntLogloss} to prevent errors resulting from a log(0)
calculation.}

\item{...}{Additional arguments.}

\item{task}{(\link{TaskSurv})}

\item{row_ids}{(\code{integer()}) \cr
Passed to \code{Learner$predict}.}

\item{newdata}{(\code{data.frame()}) \cr
If not missing \code{Learner$predict_newdata} is called instead of \code{Learner$predict}.}
}
\description{
Methods to plot prediction error curves (pecs) for either a \link{PredictionSurv} object
or a list of trained \link{LearnerSurv}s.
}
\details{
If \code{times} and \code{n} are missing then \code{measure} is evaluated over all observed time-points
from the \link{PredictionSurv} or \link{TaskSurv} object. If a range is provided for \code{times} without \code{n},
then all time-points between the range are returned.
}
\examples{
\dontrun{
library(mlr3)
task = tsk("rats")

# Prediction Error Curves for prediction object
learn = lrn("surv.coxph")
p = learn$train(task)$predict(task)
pecs(p)
pecs(p, measure = "logloss", times = c(20, 40, 60, 80)) +
  ggplot2::geom_point() +
  ggplot2::ggtitle("Logloss Prediction Error Curve for Cox PH")

# Access underlying data
x = pecs(p)
x$data

# Prediction Error Curves for fitted learners
learns = lrns(c("surv.kaplan", "surv.coxph"))
lapply(learns, function(x) x$train(task))
pecs(learns, task = task, measure = "logloss", times = c(20, 90), n = 10)
}

}
