% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Task_classif_diplodia.R
\docType{data}
\name{mlr_tasks_diplodia}
\alias{mlr_tasks_diplodia}
\alias{diplodia}
\title{Diplodia Classification Task}
\format{
\link[R6:R6Class]{R6::R6Class} inheriting from \link{TaskClassif}.
}
\usage{
data(diplodia)
}
\description{
Data set created by Patrick Schratz, University of Jena
(Germany) and Eugenia Iturritxa, NEIKER, Vitoria-Gasteiz (Spain). This
dataset should be cited as Schratz et al. (2019) (see reference below). The
publication also contains additional information on data collection. The
data set provided here shows infections of trees by the pathogen \emph{Diplodia
Sapinea} in the Basque Country in Spain. Predictors are environmental
variables like temperature, precipitation, soil and more.
}
\section{Usage}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_tasks$get("diplodia")
tsk("diplodia")
}\if{html}{\out{</div>}}
}

\references{
Schratz P, Muenchow J, Iturritxa E, Richter J, Brenning A (2019).
\dQuote{Hyperparameter tuning and performance assessment of statistical and machine-learning algorithms using spatial data.}
\emph{Ecological Modelling}, \bold{406}, 109--120.
\doi{10.1016/j.ecolmodel.2019.06.002}.
}
\seealso{
\link[mlr3misc:Dictionary]{Dictionary} of \link[=Task]{Tasks}: \link{mlr_tasks}

\code{as.data.table(mlr_tasks)} for a complete table of all (also dynamically created) \link[=Task]{Tasks}.

Other Task: 
\code{\link{TaskClassifST}},
\code{\link{TaskRegrST}},
\code{\link{mlr_tasks_cookfarm}},
\code{\link{mlr_tasks_ecuador}}
}
\concept{Task}
\keyword{datasets}
