% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.ResamplingSpCVEnv}
\alias{autoplot.ResamplingSpCVEnv}
\alias{autoplot.ResamplingRepeatedSpCVEnv}
\alias{plot.ResamplingSpCVEnv}
\alias{plot.ResamplingRepeatedSpCVEnv}
\title{Visualization Functions for SpCV Env Methods.}
\usage{
\method{autoplot}{ResamplingSpCVEnv}(
  object,
  task,
  fold_id = NULL,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  sample_fold_n = NULL,
  ...
)

\method{autoplot}{ResamplingRepeatedSpCVEnv}(
  object,
  task,
  fold_id = NULL,
  repeats_id = 1,
  plot_as_grid = TRUE,
  train_color = "#0072B5",
  test_color = "#E18727",
  sample_fold_n = NULL,
  ...
)

\method{plot}{ResamplingSpCVEnv}(x, ...)

\method{plot}{ResamplingRepeatedSpCVEnv}(x, ...)
}
\arguments{
\item{object}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSpCVEnv} or
\link{ResamplingRepeatedSpCVEnv}.}

\item{task}{\verb{[TaskClassifST]/[TaskRegrST]}\cr
mlr3 task object.}

\item{fold_id}{\verb{[numeric]}\cr
Fold IDs to plot.}

\item{plot_as_grid}{\verb{[logical(1)]}\cr
Should a gridded plot using via \CRANpkg{patchwork} be created? If \code{FALSE}
a list with of \CRANpkg{ggplot2} objects is returned.
Only applies if a numeric vector is passed to argument \code{fold_id}.}

\item{train_color}{\verb{[character(1)]}\cr
The color to use for the training set observations.}

\item{test_color}{\verb{[character(1)]}\cr
The color to use for the test set observations.}

\item{sample_fold_n}{\verb{[integer]}\cr
Number of points in a random sample stratified over partitions.
This argument aims to keep file sizes of resulting plots reasonable and
reduce overplotting in dense datasets.}

\item{...}{Passed to \code{geom_sf()}. Helpful for adjusting point sizes and
shapes.}

\item{repeats_id}{\verb{[numeric]}\cr
Repetition ID to plot.}

\item{x}{\verb{[Resampling]}\cr
mlr3 spatial resampling object of class \link{ResamplingSpCVEnv} or
\link{ResamplingRepeatedSpCVEnv}.}
}
\description{
Generic S3 \code{plot()} and \code{autoplot()} (ggplot2) methods.
}
\examples{
\donttest{
if (mlr3misc::require_namespaces(c("sf", "blockCV"), quietly = TRUE)) {
  library(mlr3)
  library(mlr3spatiotempcv)
  task = tsk("ecuador")
  resampling = rsmp("spcv_env", folds = 4, features = "dem")
  resampling$instantiate(task)

  autoplot(resampling, task) +
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))
  autoplot(resampling, task, fold_id = 1)
  autoplot(resampling, task, fold_id = c(1, 2)) *
    ggplot2::scale_x_continuous(breaks = seq(-79.085, -79.055, 0.01))
}
}
}
\seealso{
\itemize{
\item mlr3book chapter on \href{https://mlr3book.mlr-org.com/special.html#vis-spt-partitions}{"Spatiotemporal Visualization"}
\item \code{\link[=autoplot.ResamplingSpCVBlock]{autoplot.ResamplingSpCVBlock()}}
\item \code{\link[=autoplot.ResamplingSpCVBuffer]{autoplot.ResamplingSpCVBuffer()}}
\item \code{\link[=autoplot.ResamplingSpCVCoords]{autoplot.ResamplingSpCVCoords()}}
\item \code{\link[=autoplot.ResamplingSpCVDisc]{autoplot.ResamplingSpCVDisc()}}
\item \code{\link[=autoplot.ResamplingSpCVTiles]{autoplot.ResamplingSpCVTiles()}}
\item \code{\link[=autoplot.ResamplingCV]{autoplot.ResamplingCV()}}
\item \code{\link[=autoplot.ResamplingSptCVCstf]{autoplot.ResamplingSptCVCstf()}}
}
}
