% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Select.R
\name{Select}
\alias{Select}
\alias{select_all}
\alias{select_none}
\alias{select_grep}
\alias{select_name}
\alias{select_invert}
\title{Selector Functions for Character Vectors}
\usage{
select_all()

select_none()

select_grep(pattern, ignore.case = FALSE, perl = FALSE, fixed = FALSE)

select_name(param_names, assert_present = TRUE)

select_invert(select)
}
\arguments{
\item{pattern}{See \code{grep()}}

\item{ignore.case}{See \code{grep()}}

\item{perl}{See \code{grep()}}

\item{fixed}{See \code{grep()}}

\item{param_names}{The names of the parameters that you want to select}

\item{assert_present}{Whether to check that \code{param_names} is a subset of the full vector of names}

\item{select}{A \code{Select}}
}
\description{
A \code{\link{Select}} function subsets a character vector. They are used by the callback \code{CallbackSetUnfreeze} to select parameters to freeze or unfreeze during training.
}
\section{Functions}{
\itemize{
\item \code{select_all()}: \code{select_all} selects all elements

\item \code{select_none()}: \code{select_none} selects no elements

\item \code{select_grep()}: \code{select_grep} selects elements with names matching a regular expression

\item \code{select_name()}: \code{select_name} selects elements with names matching the given names

\item \code{select_invert()}: \code{select_invert} selects the elements NOT selected by the given selector

}}
\examples{
select_all()(c("a", "b"))
select_none()(c("a", "b"))
select_grep("b$")(c("ab", "ac"))
select_name("a")(c("a", "b"))
select_invert(select_all())(c("a", "b"))
}
