% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialize.R
\name{materialize_internal}
\alias{materialize_internal}
\title{Materialize a Lazy Tensor}
\usage{
materialize_internal(x, device = "cpu", cache = NULL, rbind)
}
\arguments{
\item{x}{(\code{\link[=lazy_tensor]{lazy_tensor()}})\cr
The lazy tensor to materialize.}

\item{device}{(\code{character(1L)})\cr
The device to put the materialized tensor on (after running the preprocessing graph).}

\item{cache}{(\code{NULL} or \code{environment()})\cr
Whether to cache the (intermediate) results of the materialization.
This can make data loading faster when multiple \code{lazy_tensor}s reference the same dataset or graph.}

\item{rbind}{(\code{logical(1)})\cr
Whtether to rbind the resulting tensors (\code{TRUE}) or return them as a list of tensors (\code{FALSE}).}
}
\value{
\code{\link[=lazy_tensor]{lazy_tensor()}}
}
\description{
Convert a \code{\link{lazy_tensor}} to a \code{\link[torch:torch_tensor]{torch_tensor}}.
}
\details{
Materializing a lazy tensor consists of:
\enumerate{
\item Loading the data from the internal dataset of the \code{\link{DataDescriptor}}.
\item Processing these batches in the preprocessing \code{\link[mlr3pipelines:Graph]{Graph}}s.
\item Returning the result of the \code{\link[mlr3pipelines:PipeOp]{PipeOp}} pointed to by the \code{\link{DataDescriptor}} (\code{pointer}).
}

When materializing multiple \code{\link{lazy_tensor}} columns, caching can be useful because:
a) Output(s) from the dataset might be input to multiple graphs.
(in task_dataset this is shoudl rarely be the case because because we try to merge them).
b) Different lazy tensors might be outputs from the same graph.

For this reason it is possible to provide a cache environment.
The hash key for a) is the hash of the indices and the dataset.
The hash key for b) is the hash of the indices dataset and preprocessing graph.
}
\keyword{internal}
