% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter.R
\name{autoplot.Filter}
\alias{autoplot.Filter}
\title{Plot for Filter Scores}
\usage{
\method{autoplot}{Filter}(object, type = "boxplot", n = Inf, ...)
}
\arguments{
\item{object}{(\link[mlr3filters:Filter]{mlr3filters::Filter}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{n}{(\code{integer(1)})\cr
Only include the first \code{n} features with highest importance.
Defaults to all features.}

\item{...}{(\code{any}):
Additional argument, passed down to the respective \code{geom}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3filters:Filter]{mlr3filters::Filter}, depending on argument \code{type}:
\itemize{
\item \code{"barplot"} (default): Bar plot of filter scores.
}
}
\examples{
library(mlr3)
library(mlr3viz)
library(mlr3filters)

task = tsk("mtcars")
f = flt("correlation")
f$calculate(task)

head(fortify(f))
autoplot(f, n = 5)
}
