test_that("autoplot.PredictionSurv", {
  skip_if_not_installed("mlr3proba")
  require_namespaces("mlr3proba")

  task = mlr3::tsk("rats")$filter(1:100)
  learner = suppressWarnings(mlr3::lrn("surv.coxph")$train(task))
  prediction = learner$predict(task)

  p = autoplot(prediction, type = "calib", task = task)
  expect_true(is.ggplot(p))
  vdiffr::expect_doppelganger("predictionsurv_calib", p)

  p = autoplot(prediction, type = "dcalib")
  expect_true(is.ggplot(p))
  vdiffr::expect_doppelganger("predictionsurv_dcalib", p)

  p = autoplot(prediction, type = "preds")
  expect_true(is.ggplot(p))
  vdiffr::expect_doppelganger("predictionsurv_preds", p)
})
