% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskClassif.R
\name{autoplot.TaskClassif}
\alias{autoplot.TaskClassif}
\title{Plots for Classification Tasks}
\usage{
\method{autoplot}{TaskClassif}(object, type = "target", theme = theme_minimal(), ...)
}
\arguments{
\item{object}{(\link[mlr3:TaskClassif]{mlr3::TaskClassif}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{theme}{(\code{\link[ggplot2:theme]{ggplot2::theme()}})\cr
The \code{\link[ggplot2:ggtheme]{ggplot2::theme_minimal()}} is applied by default to all plots.}

\item{...}{(ignored).}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Visualizations for \link[mlr3:TaskClassif]{mlr3::TaskClassif}.
The argument \code{type} controls what kind of plot is drawn.
Possible choices are:
\itemize{
\item \code{"target"} (default): Bar plot of the target variable (default).
\item \code{"duo"}: Passes data to \code{\link[GGally:ggduo]{GGally::ggduo()}}.
\code{columnsX} is the target and \code{columnsY} are the features.
\item \code{"pairs"}: Passes data to \code{\link[GGally:ggpairs]{GGally::ggpairs()}}.
Color is set to target column.
}
}
\examples{
if (requireNamespace("mlr3")) {
  library(mlr3)
  library(mlr3viz)

  task = tsk("iris")

  head(fortify(task))
  autoplot(task)
  autoplot(task$clone()$select(c("Sepal.Length", "Sepal.Width")),
    type = "pairs")
  autoplot(task, type = "duo")
}
}
