% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPO_meta.R
\name{cpoCache}
\alias{cpoCache}
\title{Caches the Result of CPO Transformations}
\usage{
cpoCache(cpo = NULLCPO, cache.entries = 1024)
}
\arguments{
\item{cpo}{[\code{\link{CPO}}]\cr
The \code{\link{CPO}} to wrap. The \code{\link{CPO}} may only have a single
\code{\link{OperatingType}}. Default is \code{NULLCPO}.}

\item{cache.entries}{[\code{numeric(1)}]\cr
Number of entries in the least recently used cache.}
}
\value{
[\code{\link{CPO}}].
}
\description{
This is a \code{\link{CPOConstructor}} to be used to create a
\code{\link{CPO}}. It is called like any R function and returns
the created \code{\link{CPO}}.

Given a \code{\link{CPO}} to wrap, this caches an intermediate result (in fact, the \code{\link{retrafo}} object) whenever the
CPO is applied to a Task or data.frame. This can reduce computation
time when the same CPO is often applied to the same data, e.g. in a
resampling or tuning evaluation.

The hyperparameters of the CPO are not exported, since in many cases changing the
hyperparameters will also change the result and would defeat the point of caching.
To switch between different settings of the same \code{\link{CPO}}, consider using
\code{\link{cpoMultiplex}}.

The cache is kept in an \code{\link[base]{environment}}; therefore, it does not
communicate with other threads or processes when using parallelization at a
level before the cache gets filled.

Caching needs the \sQuote{digest} package to be installed.
}
\section{General CPO info}{

This function creates a CPO object, which can be applied to
\code{\link{Task}}s, \code{data.frame}s, \code{link{Learner}}s
and other CPO objects using the \code{\link{\%>>\%}} operator.

The parameters of this object can be changed after creation
using the function \code{\link{setHyperPars}}. The other
hyper-parameter manipulating functins, \code{\link{getHyperPars}}
and \code{\link{getParamSet}} similarly work as one expects.

If the \dQuote{id} parameter is given, the hyperparameters
will have this id as aprefix; this will, however, not change
the parameters of the creator function.
}

\section{Calling a \code{\link{CPOConstructor}}}{

CPO constructor functions are called with optional values of parameters, and additional \dQuote{special} optional values.
The special optional values are the \code{id} parameter, and the \code{affect.*} parameters. The \code{affect.*} parameters
enable the user to control which subset of a given dataset is affected. If no \code{affect.*} parameters are given, all
data features are affected by default.
}

\seealso{
Other CPOs: 
\code{\link{cpoApplyFunRegrTarget}()},
\code{\link{cpoApplyFun}()},
\code{\link{cpoAsNumeric}()},
\code{\link{cpoCbind}()},
\code{\link{cpoCollapseFact}()},
\code{\link{cpoDropConstants}()},
\code{\link{cpoDummyEncode}()},
\code{\link{cpoFilterAnova}()},
\code{\link{cpoFilterCarscore}()},
\code{\link{cpoFilterChiSquared}()},
\code{\link{cpoFilterFeatures}()},
\code{\link{cpoFilterGainRatio}()},
\code{\link{cpoFilterInformationGain}()},
\code{\link{cpoFilterKruskal}()},
\code{\link{cpoFilterLinearCorrelation}()},
\code{\link{cpoFilterMrmr}()},
\code{\link{cpoFilterOneR}()},
\code{\link{cpoFilterPermutationImportance}()},
\code{\link{cpoFilterRankCorrelation}()},
\code{\link{cpoFilterRelief}()},
\code{\link{cpoFilterRfCImportance}()},
\code{\link{cpoFilterRfImportance}()},
\code{\link{cpoFilterRfSRCImportance}()},
\code{\link{cpoFilterRfSRCMinDepth}()},
\code{\link{cpoFilterSymmetricalUncertainty}()},
\code{\link{cpoFilterUnivariate}()},
\code{\link{cpoFilterVariance}()},
\code{\link{cpoFixFactors}()},
\code{\link{cpoIca}()},
\code{\link{cpoImpactEncodeClassif}()},
\code{\link{cpoImpactEncodeRegr}()},
\code{\link{cpoImputeConstant}()},
\code{\link{cpoImputeHist}()},
\code{\link{cpoImputeLearner}()},
\code{\link{cpoImputeMax}()},
\code{\link{cpoImputeMean}()},
\code{\link{cpoImputeMedian}()},
\code{\link{cpoImputeMin}()},
\code{\link{cpoImputeMode}()},
\code{\link{cpoImputeNormal}()},
\code{\link{cpoImputeUniform}()},
\code{\link{cpoImpute}()},
\code{\link{cpoLogTrafoRegr}()},
\code{\link{cpoMakeCols}()},
\code{\link{cpoMissingIndicators}()},
\code{\link{cpoModelMatrix}()},
\code{\link{cpoOversample}()},
\code{\link{cpoPca}()},
\code{\link{cpoProbEncode}()},
\code{\link{cpoQuantileBinNumerics}()},
\code{\link{cpoRegrResiduals}()},
\code{\link{cpoResponseFromSE}()},
\code{\link{cpoSample}()},
\code{\link{cpoScaleMaxAbs}()},
\code{\link{cpoScaleRange}()},
\code{\link{cpoScale}()},
\code{\link{cpoSelect}()},
\code{\link{cpoSmote}()},
\code{\link{cpoSpatialSign}()},
\code{\link{cpoTransformParams}()},
\code{\link{cpoWrap}()},
\code{\link{makeCPOCase}()},
\code{\link{makeCPOMultiplex}()}
}
\concept{CPOs}
