% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrpro.R
\name{mlrpro-package}
\alias{mlrpro-package}
\alias{mlrpro}
\title{Perform stepwise regression with verifying assumptions and identifying possible Box-Cox transformation}
\usage{
mlrpro(Data,Y,Column_Y,Alpha)
}
\arguments{
\item{Data}{a data frame containing the variables in the model.}

\item{Y}{the response variable.}

\item{Column_Y}{the column response variable.}

\item{Alpha}{significance level.}
}
\value{
An object of class \code{mlrpro} is a list containing at least the following components:
\item{coefficients}{a named vector of coefficients.}
\item{residuals}{the residuals, that is response minus fitted values.}
\item{fitted.values}{the fitted mean values.}
\item{rank}{the numeric rank of the fitted linear model.}
\item{df.residual}{the residual degrees of freedom.}
\item{call}{the matched call.}
\item{terms}{the terms object used.}
\item{model}{if requested (the default), the model frame used.}
\item{lambda}{lambda value utilized in the data conversion.}
}
\description{
A tool for multiple regression, select independent variables,
check multiple linear regression assumptions and identify possible.
}
\examples{
data(trees)
Model.mlrpro <- mlrpro(Data = trees,Y = trees$Volume, Column_Y = 3, Alpha = 0.05)
}
