% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mlsjunkgend.R
\name{mlsjunkgend}
\alias{mlsjunkgend}
\title{Generate a data frame of pseudo-random numbers using the MLS Junk Generator algorithm}
\usage{
mlsjunkgend(n = 1, w, x, y, z, round = 5)
}
\arguments{
\item{n}{the number of pseudo-random numbers to generate; defaults to 1}

\item{w}{the first seed required by the MLS Junk Generator algorithm}

\item{x}{the first seed required by the MLS Junk Generator algorithm}

\item{y}{the first seed required by the MLS Junk Generator algorithm}

\item{z}{the first seed required by the MLS Junk Generator algorithm}

\item{round}{the number of decimal places to which to round the pseudo-random numbers; default = 5}
}
\value{
A numeric vector containing a single pseudo-random number
}
\description{
Based on user input seeds, this function generates a data frame of n
pseudo-random numbers and names the column containing these as "RN" for "random
numbers."  This is achieved by calling junkgen.
}
\examples{
# Generate a pseudo-random number data frame with 10 observations from user-specified seeds

w <- 1
x <- 2
y <- 3
z <- 4

mlsjunkgend(n = 10, w = w, x = x, y = y, z = z) # returns a data frame of 10 observations

# Specifying different values for n and round

mlsjunkgend(n = 5, w = w, x = x, y = y, z = z, round = 2)
# returns a data frame identical to the above example but with only 5 observations
# rounded to 2 decimal places

# using the default value of n (1) is identical to assigning the rounded result of
# junkgen to a data frame of 1 observation

junkgen(w = w, x = x, y = y, z = z) # returns "[1] 0.9551644"
mlsjunkgend(w = w, x = x, y = y, z = z)
# returns the following:
#        RN
# 1 0.95516
}

