% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcc.R
\name{mcc}
\alias{mcc}
\title{Matthews correlation coefficient}
\usage{
mcc(preds = NULL, actuals = NULL, TP = NULL, FP = NULL, TN = NULL,
  FN = NULL)
}
\arguments{
\item{preds}{A vector of prediction values in {1, 0}, or {TRUE, FALSE}}

\item{actuals}{A vector of actuals values in {1, 0}, or {TRUE, FALSE}}

\item{TP}{Count of true positives (correctly predicted 1/TRUE)}

\item{FP}{Count of false positives (predicted 1/TRUE, but actually 0/FALSE)}

\item{TN}{Count of true negatives (correctly predicted 0/FALSE)}

\item{FN}{Count of false negatives (predicted 0/FALSE, but actually 1/TRUE)}
}
\description{
Calculate Matthews correlation coefficient
}
\details{
Calculate Matthews correlation coefficient. Either

\itemize{
 \item{\code{preds} and \code{actuals} can be given, leaving \code{TP}, \code{FP}, \code{TN}, and \code{FN} NULL} or
 \item{\code{TP}, \code{FP}, \code{TN}, and \code{FN} can be given, leaving \code{preds} and \code{actuals} NULL}
}
}
\examples{
preds <- c(1,1,1,0,1,1,0,0)
actuals <- c(1,1,1,1,0,0,0,0)
mcc(preds, actuals)
mcc(actuals, actuals)
mcc(TP=3, FP=2, TN=2, FN=1)

}
\references{
\url{https://en.wikipedia.org/wiki/Matthews_correlation_coefficient}
}
