% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_dmrs.R
\name{compare_dmrs}
\alias{compare_dmrs}
\title{Compare Differentially Methylated Regions (DMRs) from Two Methods}
\usage{
compare_dmrs(rst1, rst2)
}
\arguments{
\item{rst1}{A data frame containing the first set of DMR results. Must contain
columns: `Chromosome`, `Start_CpG`, and `End_CpG`.}

\item{rst2}{A data frame containing the second set of DMR results. Must contain
columns: `Chromosome`, `Start_CpG`, and `End_CpG`.}
}
\value{
A data frame with the following columns:
\item{Chromosome}{Chromosome name of the overlapping region}
\item{Start_CpG_Method1}{Start CpG site from the first method}
\item{End_CpG_Method1}{End CpG site from the first method}
\item{Start_CpG_Method2}{Start CpG site from the second method}
\item{End_CpG_Method2}{End CpG site from the second method}
\item{Overlap_Percentage}{Percentage of overlap}

Returns NULL if no overlaps are found.
}
\description{
Identifies and analyzes overlapping regions between two sets of differentially 
methylated regions (DMRs) detected by different methods.
Computes overlap percentages to assess consistency between detection approaches.
}
\details{
This function performs comparison of genomic regions between two DMR detection
results. It identifies both partial and complete overlaps between regions and 
calculates overlap percentage by total region size.
}
\examples{
\donttest{
# Create sample DMR results
dmr_method1 <- data.frame(
  Chromosome = c("chr1", "chr1", "chr2"),
  Start_CpG = c("cg0001", "cg0050", "cg0100"),
  End_CpG = c("cg0020", "cg0070", "cg0150")
)

dmr_method2 <- data.frame(
  Chromosome = c("chr1", "chr2", "chr2"),
  Start_CpG = c("cg0005", "cg0120", "cg0090"),
  End_CpG = c("cg0025", "cg0160", "cg0110")
)

# Compare overlapping regions
overlaps <- compare_dmrs(dmr_method1, dmr_method2)
}

}
\seealso{
Related functions in this package:
\code{\link{mmcmcBayes}} for DMR detection using multi-stage MCMC,
\code{\link{asgn_func}} for parameter estimation with ASGN distribution
}
\author{
Zhexuan Yang, Duchwan Ryu, and Feng Luan
}
