% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_to_server.R
\name{vec_null}
\alias{vec_null}
\title{Handle Null Values for Text to Vector Conversion}
\usage{
vec_null(par_input = "", alt_na = NULL)
}
\arguments{
\item{par_input}{A string input, default is "".}

\item{alt_na}{If alt_na is not set to NULL (the default), then it is an
alternative string used to represent NA. Usually, this is a string such as
"NA", "NaN", etc.}
}
\value{
NULL if input is NA, if input is empty, or if input is alt_na (and alt_na
is not NULL). Otherwise, return a vector.
}
\description{
Handle Null Values for Text to Vector Conversion
}
\examples{
# Convert missing value to NULL
vec_null()
vec_null(NA)
vec_null("na", alt_na="na")

# Convert string to vector when input is not missing
num_vec <- vec_null("2,8,3,7")

# Convert string to NULL when a single element is missing
vec_null("2,3,NA,5", "NA")

}
