% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{uniformGrid}
\alias{uniformGrid}
\title{method to create a uniform grid on a variable}
\usage{
uniformGrid(x, length.out)
}
\arguments{
\item{x}{a vector, matrix, or \code{data.frame} to create a grid on.}

\item{length.out}{an integer giving the length of the grid.}
}
\value{
an object of the same type as \code{x}, with \code{length.out} or fewer unique values.
}
\description{
generates an evenly spaced grid given an input vector, matrix, or \code{data.frame} which has size \code{length.out}.
}
\note{
for unordered factors and characters, if \code{length.out < length(unique(x))} \code{length.out} is set to \code{length(unique(x))}. if \code{x} is a \code{data.frame} and this is true of some columns but not others, there will be a warning.
}
\examples{

data = data.frame(
  w = seq(0, 1, length.out = 5),
  x = factor(letters[1:5]),
  y = ordered(1:5),
  z = 1:5
)

lapply(data, uniformGrid, length.out = 5)
}

