% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parzen.R
\name{parzen}
\alias{parzen}
\alias{Parzen}
\title{Parzen's Kernel mode estimator}
\usage{
parzen(x, bw = NULL, kernel = "gaussian", abc = FALSE,
  par = shorth(x), optim.method = "BFGS", ...)
}
\arguments{
\item{x}{numeric. Vector of observations.}

\item{bw}{numeric. The smoothing bandwidth to be used.}

\item{kernel}{character. The kernel to be used. Available kernels are 
\code{"biweight"}, \code{"cosine"}, \code{"eddy"}, \code{"epanechnikov"}, 
\code{"gaussian"}, \code{"optcosine"}, \code{"rectangular"}, 
\code{"triangular"}, \code{"uniform"}. 
See \code{\link[stats]{density}} for more details on some of these kernels.}

\item{abc}{logical. If \code{FALSE} (the default), the kernel density estimate 
is maximised using \code{\link[stats]{optim}}.}

\item{par}{numeric. The initial value used in \code{\link[stats]{optim}}.}

\item{optim.method}{character. If \code{abc = FALSE}, the method used in \code{\link[stats]{optim}}.}

\item{...}{If \code{abc = FALSE}, further arguments to be passed to \code{\link[stats]{optim}}.}
}
\value{
\code{parzen} returns a numeric value, the mode estimate. 
If \code{abc = TRUE}, the \code{x} value maximizing the density 
estimate is returned. Otherwise, the \code{\link[stats]{optim}} 
method is used to perform maximization, and the attributes: 
'value', 'counts', 'convergence' and 'message', coming from 
the \code{\link[stats]{optim}} method, are added to the result.
}
\description{
Parzen's kernel mode estimator is the value 
maximizing the kernel density estimate.
}
\details{
If \code{kernel = "uniform"}, the \code{\link[modeest]{naive}} mode estimate is returned.
}
\note{
The user should preferentially call \code{parzen} through 
\code{mlv(x, method = "kernel", ...)} or \code{mlv(x, method = "parzen", ...)}. 

Presently, \code{parzen} is quite slow.
}
\examples{
# Unimodal distribution 
x <- rlnorm(10000, meanlog = 3.4, sdlog = 0.2) 

## True mode 
lnormMode(meanlog = 3.4, sdlog = 0.2) 

## Estimate of the mode 
mlv(x, method = "kernel", kernel = "gaussian", bw = 0.3, par = shorth(x)) 

}
\references{
\itemize{ 
\item Parzen E. (1962). 
On estimation of a probability density function and mode. 
\emph{Ann. Math. Stat.}, \bold{33}(3):1065--1076. 

\item Konakov V.D. (1973). 
On the asymptotic normality of the mode of multidimensional distributions. 
\emph{Theory Probab. Appl.}, \bold{18}:794-803. 

\item Eddy W.F. (1980). 
Optimum kernel estimators of the mode. 
\emph{Ann. Statist.}, \bold{8}(4):870-882.

\item Eddy W.F. (1982). 
The Asymptotic Distributions of Kernel Estimators of the Mode. 
\emph{Z. Wahrsch. Verw. Gebiete}, \bold{59}:279-290. 

\item Romano J.P. (1988). 
On weak convergence and optimality of kernel density estimates of the mode. 
\emph{Ann. Statist.}, \bold{16}(2):629-647. 

\item Abraham C., Biau G. and Cadre B. (2003). 
Simple Estimation of the Mode of a Multivariate Density. 
\emph{Canad. J. Statist.}, \bold{31}(1):23-34. 

\item Abraham C., Biau G. and Cadre B. (2004). 
On the Asymptotic Properties of a Simple Estimate of the Mode. 
\emph{ESAIM Probab. Stat.}, \bold{8}:1-11. 
}
}
\seealso{
\code{\link[modeest]{mlv}}, \code{\link[modeest]{naive}}
}
