% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildModelObj.R
\name{buildModelObj}
\alias{buildModelObj}
\title{Create an Object of Class modelObj}
\usage{
buildModelObj(
  model,
  solver.method = NULL,
  solver.args = NULL,
  predict.method = NULL,
  predict.args = NULL
)
}
\arguments{
\item{model}{An object of class formula; the model.}

\item{solver.method}{An object of class character specifying the name of
the R function to be used to obtain parameter estimates. Or, the function  
to be used to obtain parameter estimates. For example,  `lm', `glm',  
or `rpart'. The specified modeling function MUST have a corresponding  
predict method.}

\item{solver.args}{An object of class list containing additional arguments 
  to be sent to solver.method.  Arguments must be provided as a list, where  
  the name of each element matches a formal argument of solver.method. For  
  example, if a logistic regression using glm is desired, 
  \deqn{solver.method = ``glm"}
  \deqn{solver.args = list(``family"=binomial)}

  A solver.method can takes formal arguments 'formula' and 'data' as inputs, 
  such as lm and glm. Some R methods do not use formal names 'formula' and 
  'data'; a user can indicate if a different naming convention is used for 
  these two input arguments. For example, if a method expects the formula 
  object to be passed through input variable \code{x},  
  \code{solver.args} <- list("x"="formula")

  A solver.method can also take formal arguments 'x' and 'y' as inputs,  
  such as glmnet. Some R methods do not use formal names 'x' and 'y' to  
  indicate the covariate and response; a user can indicate if a different 
  naming convention is used for these two input arguments. For example, if a
  method expects the covariate matrix to be passed through input variable  
  \code{X}, \code{solver.args} <- list("X"="x")}

\item{predict.method}{A character. The name of the R function or the
function to be used to obtain predictions. For example,  `predict.lm',  
`predict', or `predict.glm'. If no function is explicitly given, the  
generic \code{predict} is assumed. For many methods, the generic method  
is appropriate.}

\item{predict.args}{A list. Additional arguments to be sent to
  predict.method. This must be provided as a list, where the name of each  
  element matches a formal argument of predict.method. For example, if a  
  logistic regression using glm was used to fit the model formula object  
  and predictions on the scale of the response are desired, 
   \deqn{predict.method = ``predict.glm"}
   \deqn{predict.args = list(``type"=``response").}

  It is assumed that the predict.method has formal arguments ``object"  
  and ``newdata". If predict.method does not use these formal arguments,  
  predict.args must explicitly indicate the variable names used for these  
  inputs. For example, list(``newx"=``newdata") if the new data is passed  
  to predict.method through input argument ``newx".}
}
\value{
An object of class \code{modelObjFormula} or \code{modelObjXY}, which
  inherit directly from \link{modelObj}.
}
\description{
A utility function to transfer user defined models and estimation methods 
  to an object of class modelObj.
}
\details{
Unless changed by the user in solver.args and/or predict.args, default 
  settings are assumed for the specified regression and prediction methods.
}
\examples{
   #----------------------------------------------------#
   # Create modeling object using a formula
   #----------------------------------------------------#
   mo <- buildModelObj(model=Y ~ X1 + X2 + X3 + X4,
                       solver.method='lm', 
                       predict.method='predict.lm',
                       predict.args=list(type='response'))
}
