
#'
#' A dataset of COVID-19 outbreak in Hong Kong
#'
#'
#' @description
#' This dataset (i.e., \code{COVID19_JanApr2020_HongKong}) contains 290 observations of **offspring case number** generated by one seed case,
#' which were collected during the coronavirus disease 2019 (COVID-19) outbreak in Hong Kong, China from January to April 2020.
#'
#'
#' @format
#' A data frame (\code{data.frame}) with 290 rows of records, and 2 columns of variables:
#' \describe{
#'   \item{\code{obs}}{Observations of offspring (or secondary) case numbers generated by each seed case.}
#'   \item{\code{type}}{A categorical variable takes the value "secondary" indicating the type of observations.}
#' }
#'
#' @source
#' Summary of data and outbreak situation of the Severe Respiratory Disease associated with a Novel Infectious Agent,
#' released by the Centre for Health Protection, Department of Health, the Government of the Hong Kong Special Administrative Region.
#' See for example, <https://www.coronavirus.gov.hk/eng/index.html>
#'
#' @references
#' Adam DC, Wu P, Wong JY, Lau EH, Tsang TK, Cauchemez S, Leung GM, Cowling BJ. Clustering and superspreading potential of SARS-CoV-2 infections in Hong Kong. *Nature Medicine*. 2020;26(11):1714-1719.
#' \doi{10.1038/s41591-020-1092-0}
#'
#' @examples
#' data(COVID19_JanApr2020_HongKong)
#' summary(COVID19_JanApr2020_HongKong)
#' table(COVID19_JanApr2020_HongKong$obs)
#'
"COVID19_JanApr2020_HongKong"
















#'
#' A dataset of smallpox outbreaks in Europe
#'
#'
#' @description
#' This dataset (i.e., \code{smallpox_19581973_Europe}) contains 34 observations of **next-generation cluster size** generated by given numbers of seed cases,
#' which were collected in smallpox outbreaks in Europe from 1958 to 1973.
#' Here, in this dataset, only the smallpox case observations involved in the *first* indigenous transmission generation were recorded.
#'
#'
#' @format
#' A data frame (\code{data.frame}) with 34 of records, and 3 columns of variables:
#' \describe{
#'   \item{\code{obs.seed}}{Observations of the number of seed cases that generated the offspring cases in the next transmission generation.}
#'   \item{\code{obs.clustersize}}{Observations of next-generation cluster size generated by given numbers (given in \code{obs.seed}) of seed cases.}
#'   \item{\code{type.obs}}{A categorical variable takes the value "nextgen_clustersize" indicating the type of observations.}
#' }
#'
#' @references
#' Fenner F, Henderson DA, Arita I, Jezek Z, Ladnyi ID. Smallpox and its eradication. *Geneva: World Health Organization*. 1988.
#' <https://apps.who.int/iris/handle/10665/39485>, see Table 23.4 for the raw data.
#'
#' Blumberg S, Funk S, Pulliam JR. Detecting differential transmissibilities that affect the size of self-limited outbreaks. *PLoS Pathogens*. 2014;10(10):e1004452.
#' \doi{10.1371/journal.ppat.1004452}, see Table 3 in the data supplementary file for the processed data.
#'
#' @examples
#' data(smallpox_19581973_Europe)
#' summary(smallpox_19581973_Europe)
#'
"smallpox_19581973_Europe"












#'
#' A dataset of MERS outbreaks in the Middle East region
#'
#'
#' @description
#' This dataset (i.e., \code{MERS_2013_MEregion}) contains 55 observations of **final outbreak size** generated by given numbers of seed cases,
#' which were collected in Middle East respiratory syndrome (MERS) outbreaks in the Middle East (ME) regions in 2013.
#'
#'
#' @format
#' A data frame (\code{data.frame}) with 55 rows of records, and 3 columns of variables:
#' \describe{
#'   \item{\code{obs.seed}}{Observations of the number of seed cases that generated the outbreak.}
#'   \item{\code{obs.finalsize}}{Observations of final outbreak size generated by given numbers (given in \code{obs.seed}) of seed cases.}
#'   \item{\code{type}}{A categorical variable takes the value "outbreaksize" indicating the type of observations.}
#' }
#'
#' @references
#' Poletto C, Pelat C, Levy-Bruhl D, Yazdanpanah Y, Boelle PY, Colizza V. Assessment of the Middle East respiratory syndrome coronavirus (MERS-CoV) epidemic in the Middle East and risk of international spread using a novel maximum likelihood analysis approach. *Eurosurveillance*. 2014;19(23):20824.
#' \doi{10.2807/1560-7917.ES2014.19.23.20824}, see the "baseline" column in Table 1 for the raw data.
#'
#' Kucharski AJ, Althaus CL. The role of superspreading in Middle East respiratory syndrome coronavirus (MERS-CoV) transmission. *Eurosurveillance*. 2015;20(25):21167.
#' \doi{10.2807/1560-7917.ES2015.20.25.21167}
#'
#' @examples
#' data(MERS_2013_MEregion)
#' summary(MERS_2013_MEregion)
#'
"MERS_2013_MEregion"
















#'
#' A dataset of mpox outbreaks in DRC
#'
#'
#' @description
#' This dataset (i.e., \code{mpox_19801984_DRC}) contains 125 observations of one of the following types:
#' \itemize{
#'   \item{**offspring case number**}{, }
#'   \item{**next-generation cluster size**}{, and }
#'   \item{**final outbreak size**}{, }
#' }
#' generated by given numbers of seed cases,
#' which were collected in mpox (i.e., monkeypox) outbreaks in Democratic Republic of the Congo (DRC, or previous named "Zaire" before 1997) from 1980 to 1984.
#'
#'
#' @format
#' A data frame (\code{data.frame}) with 125 rows of records, and 3 columns of variables:
#' \describe{
#'   \item{\code{obs.seed}}{Observations of the number of seed cases that generated the offspring cases in the next transmission generation.}
#'   \item{\code{obs.size}}{Observations of cases numbers generated by given numbers (given in \code{obs.seed}) of seed cases, see \code{type} variable for the detailed meaning of the value recorded under this variable here.}
#'   \item{\code{type}}{
#'     A categorical variable takes one of the 3 values indicating the type of observations for \code{obs.size} as follows:
#'     \itemize{
#'       \item{\code{"offpring"}}{ indicated the **offspring case number**, generated by 1 seed case for each observation.}
#'       \item{\code{"nextgen"}}{ indicated the **next-generation cluster size** (including seed cases), generated by a group of seed cases with size given in \code{obs.seed}.}
#'       \item{\code{"outbreak"}}{ indicated the **final outbreak size** (including seed cases), generated by a group of seed cases with size given in \code{obs.seed}.}
#'     }
#'   }
#' }
#'
#' @details
#' Note one difference between \code{mpox_19801984_DRC} and the original dataset (i.e., the dataset presented in reference) was that for simplicity, observations in the original dataset that involved transmission chains of more than 1 generation were aggregated as **final outbreak size** observations in \code{mpox_19801984_DRC}.
#'
#' @references
#' Fine PE, Jezek Z, Grab B, Dixon H. The transmission potential of monkeypox virus in human populations. *International Journal of Epidemiology*. 1988;17(3):643-650.
#' \doi{10.1093/ije/17.3.643}, see Table 1 for the raw data.
#'
#'
#' @examples
#' data(mpox_19801984_DRC)
#' summary(mpox_19801984_DRC)
#' table(mpox_19801984_DRC$type)
#'
"mpox_19801984_DRC"








