% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_draws.R
\name{reshape_draws}
\alias{reshape_draws}
\title{Reshape estimations with Bayesian posterior draws to long format}
\usage{
reshape_draws(draws)
}
\arguments{
\item{draws}{data.frame containing posterior draws obtained from \code{estimate_response} or \code{estimate_link}.}
}
\value{
Dataframe of reshaped draws in long format.
}
\description{
Reshape data.frame of estimations with Bayesian posterior draws to long format.
}
\examples{
\donttest{
library(rstanarm)
model <- stan_glm(Sepal.Width ~ Species * Petal.Length, data = iris)
estimates <- estimate_response(model, keep_draws = TRUE, draws = 200)
reshape_draws(estimates)
}
}
