% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_means.R
\name{estimate_means}
\alias{estimate_means}
\title{Estimate average value of response variable at each factor levels}
\usage{
estimate_means(
  model,
  levels = NULL,
  fixed = NULL,
  modulate = NULL,
  transform = "response",
  length = 10,
  centrality = "median",
  ci = 0.95,
  ci_method = "hdi",
  ...
)
}
\arguments{
\item{model}{A statistical model.}

\item{levels}{A character vector or formula specifying the names of the
predictors over which to estimate means or contrasts.}

\item{fixed}{A character vector indicating the names of the predictors to be
"fixed" (i.e., maintained), so that the estimation is made at these values.}

\item{modulate}{A character vector indicating the names of a numeric variable
along which the means or the contrasts will be estimated. Adjust its length
using \code{length}.}

\item{transform}{Can be \code{"none"} (default for contrasts),
\code{"response"} (default for means), \code{"mu"}, \code{"unlink"},
\code{"log"}. \code{"none"}  will leave the values on scale of the linear
predictors. \code{"response"} will transform them on scale of the response
variable. Thus for a logistic model, \code{"none"} will give estimations
expressed in log-odds (probabilities on logit scale) and \code{"response"}
in terms of probabilities.}

\item{length}{Length of the spread numeric variables.}

\item{centrality, ci, ci_method}{Arguments for Bayesian models.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A dataframe of estimated marginal means.
}
\description{
Estimate average value of response variable at each factor levels
}
\examples{
library(modelbased)

model <- lm(Petal.Length ~ Sepal.Width * Species, data = iris)

estimate_means(model)
estimate_means(model, fixed = "Sepal.Width")
estimate_means(model, levels = c("Species", "Sepal.Width"), length = 2)
estimate_means(model, levels = "Species=c('versicolor', 'setosa')")
estimate_means(model, levels = "Sepal.Width=c(2, 4)")
estimate_means(model, levels = c("Species", "Sepal.Width=0"))
estimate_means(model, modulate = "Sepal.Width", length = 5)
estimate_means(model, modulate = "Sepal.Width=c(2, 4)")
\dontrun{
if (require("lme4")) {
  data <- iris
  data$Petal.Length_factor <- ifelse(data$Petal.Length < 4.2, "A", "B")

  model <- lmer(Petal.Length ~ Sepal.Width + Species + (1 | Petal.Length_factor), data = data)
  estimate_means(model)
  estimate_means(model, modulate = "Sepal.Width", length = 3)
}
}
\donttest{
data <- mtcars
data$cyl <- as.factor(data$cyl)
data$am <- as.factor(data$am)

if (require("rstanarm")) {
  model <- stan_glm(mpg ~ cyl * am, data = data, refresh = 0)
  estimate_means(model)

  model <- stan_glm(mpg ~ cyl * wt, data = data, refresh = 0)
  estimate_means(model)
  estimate_means(model, modulate = "wt")
  estimate_means(model, fixed = "wt")
}
}

\dontrun{
if (require("brms")) {
  model <- brm(mpg ~ cyl * am, data = data, refresh = 0)
  estimate_means(model)
}
}

}
