% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_fit.R
\name{set_fit}
\alias{set_fit}
\alias{get_fit}
\title{Register Fit method for Model}
\usage{
set_fit(model, mode, eng, value)

get_fit(model)
}
\arguments{
\item{model}{A single character string for the model type (e.g.
\code{"k_means"}, etc).}

\item{mode}{A single character string for the model mode (e.g. "partition").}

\item{eng}{A single character string for the model engine.}

\item{value}{A list of values, described in the Details.}
}
\value{
A tibble
}
\description{
This function is used to register a fit method for a model, engine, and mode
combination.
}
\details{
The list passed to \code{value} needs the following values:
\itemize{
\item \strong{interface} is a single character value that could be \verb{“formula”},
\verb{“data.frame”}, or \verb{“matrix”}. This defines the type of interface used by
the underlying fit function (\code{stats::lm}, in this case). This helps the
translation of the data to be in an appropriate format for the that
function.
\item \strong{protect} is an optional list of function arguments that should not be
changeable by the user. In this case, we probably don’t want users to pass
data values to these arguments (until the \code{fit()} function is called).
\item \strong{func} is the package and name of the function that will be called. If
you are using a locally defined function, only \code{fun} is required.
\item \strong{defaults} is an optional list of arguments to the fit function that the
user can change, but whose defaults can be set here. This isn’t needed in
this case, but is described later in this document.
}
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_new_model("shallow_learning_model")
set_model_mode("shallow_learning_model", "partition")
set_model_engine("shallow_learning_model", "partition", "stats")

set_fit(
  model = "shallow_learning_model",
  mode = "partition",
  eng = "stats",
  value = list(
    interface = "formula",
    protect = c("formula", "data"),
    func = c(pkg = "stats", fun = "lm"),
    defaults = list()
  )
)

get_fit("shallow_learning_model")
get_fit("shallow_learning_model")$value
\dontshow{\}) # examplesIf}
}
