% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_statistics.R
\name{proc_freq}
\alias{proc_freq}
\title{View and return the frequency distribution of a variable.}
\usage{
proc_freq(dat, var, bins = 0)
}
\arguments{
\item{dat}{a tbl}

\item{var}{character string giving the name of the desired variable, or
a single number giving the position of the desired variable}

\item{bins}{if 0, no discretization is performed. If a positive integer then
\code{var} is binned into \code{bins} equal width ranges, and the
frequency distribution of those ranges is computed. If a length > 1
numeric vector, then \code{var} is binned into ranges with cutpoints
defined by the unique entries of \code{bins}}
}
\value{
a tbl containing 3 columns: \code{level} gives the unique values or
        bins, \code{count} gives the count in each level of \code{level} and
        \code{percent} gives the percentage of total observations in each
        level. \code{proc_freq} also automatically sends the frequency
        distribution to the viewer, using \code{utils::View}
}
\description{
For continuous variables, the user can optionally specify to discretize the
variable into a fixed number of equal width bins, or into custom bins of the
user's choice. This is useful for larger datasets with many unique
observed values
}
\details{
R has many one-line solutions to getting the frequency distribution of a
variable; this function provides a unified approach that makes use of the
efficient data types and computation provided by the \code{dplyr} package,
and as a bonus, makes it easy to explore the distribution of a continuous
variable with many unique observations by automating discretization. The name
is intended to make the function more portable for SAS users who are not
comfortable outside their native habitat.
}
\examples{
proc_freq(faithful,"eruptions")
proc_freq(faithful,"eruptions",bins = 4)
proc_freq(faithful,"eruptions",bins = c(1,2,3,4,5))


}
\seealso{
Other descriptive: \code{\link{get_top_corrs}}
}

