% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numbers_math.R
\name{bin.entropy.modello_number}
\alias{bin.entropy.modello_number}
\alias{bin.entropy.default}
\alias{bin.entropy}
\title{Binary Entropy}
\usage{
\method{bin.entropy}{modello_number}(y, yh)

\method{bin.entropy}{default}(y, yh)

bin.entropy(y, yh)
}
\arguments{
\item{y}{predicted probability}

\item{yh}{target classes (0 or 1)}
}
\value{
Returns the entropy
}
\description{
Entropy for binary target variables (Negative Bernoulli Log-Likelihood)
\deqn{h = \sum_i{-y_i * log(\hat y_i) - (1- y_i) * log(1 - \hat y_i)}}
}
\examples{
modello.init()
## For modello_numbers
y = number(sample(c(1, 0), 10, replace=TRUE), dx=FALSE)
yh = number(runif(10))
h = bin.entropy(y, yh)
print(h)
print(h$v)
modello.close()
## For numerics
y = sample(c(1, 0), 10, replace=TRUE)
yh = runif(10)
h = bin.entropy(y, yh)
print(h)
}
\author{
Filippo Monari
}
