% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_statistic_override.R
\name{statistic_override_vector}
\alias{statistic_override_vector}
\title{Use the statistic_override vector to extract std.error/p.value/statistic}
\usage{
statistic_override_vector(model, statistic_override, statistic)
}
\arguments{
\item{model}{object type with an available `tidy` method.}

\item{statistic_override}{manually override the uncertainy estimates. This
argument accepts three types of input:
\itemize{
  \item a function or list of functions of length(models) which produce variance-covariance matrices with row and column names equal to the names of your coefficient estimates. For example, `R` supplies the `vcov` function, and the `sandwich` package supplies `vcovHC`, `vcovHAC`, etc.
  \item a list of length(models) variance-covariance matrices with row and column names equal to the names of your coefficient estimates.
  \item a list of length(models) vectors with names equal to the names of your coefficient estimates. Numeric vectors are formatted according to `fmt` and placed in brackets, character vectors printed as given.
}}

\item{statistic}{string name of the statistic to include in parentheses
\itemize{
  \item Typical values: "conf.int", "std.error", "statistic", "p.value"
  \item Alternative values: any column name produced by `broom::tidy(model)`
}}
}
\value{
tibble
}
\description{
Use the statistic_override vector to extract std.error/p.value/statistic
}
\keyword{internal}
