% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasummary_crosstab.R
\name{datasummary_crosstab}
\alias{datasummary_crosstab}
\title{Cross tabulations for categorical variables}
\usage{
datasummary_crosstab(
  formula,
  statistic = 1 ~ 1 + N + Percent("row"),
  data,
  output = "default",
  fmt = 1,
  title = NULL,
  notes = NULL,
  align = NULL,
  add_columns = NULL,
  add_rows = NULL,
  sparse_header = TRUE,
  escape = TRUE,
  ...
)
}
\arguments{
\item{formula}{A two-sided formula to describe the table: rows ~ columns,
where rows and columns are variables in the data. Rows and columns may
contain interactions, e.g., \code{var1 * var2 ~ var3}.}

\item{statistic}{A formula of the form \code{1 ~ 1 + N + Percent("row")}. The
left-hand side may only be empty or contain a \code{1} to include row totals.
The right-hand side may contain: \code{1} for column totals, \code{N} for counts,
\code{Percent()} for cell percentages, \code{Percent("row")} for row percentages,
\code{Percent("col")} for column percentages.}

\item{data}{A data.frame (or tibble)}

\item{output}{filename or object type (character string)
\itemize{
\item Supported filename extensions: .docx, .html, .tex, .md, .txt, .csv, .xlsx, .png, .jpg
\item Supported object types: "default", "html", "markdown", "latex", "latex_tabular", "data.frame", "gt", "kableExtra", "huxtable", "flextable", "DT", "jupyter". The "modelsummary_list" value produces a lightweight object which can be saved and fed back to the \code{modelsummary} function.
\item The "default" output format can be set to "kableExtra", "gt", "flextable", "huxtable", "DT", or "markdown"
\itemize{
\item If the user does not choose a default value, the packages listed above are tried in sequence.
\item Session-specific configuration: \code{options("modelsummary_factory_default" = "gt")}
\item Persistent configuration: \code{modelsummary_config(output = "markdown")}
}
\item Warning: Users should not supply a file name to the \code{output} argument if they intend to customize the table with external packages. See the 'Details' section.
\item LaTeX compilation requires the \code{booktabs} and \code{siunitx} packages, but \code{siunitx} can be disabled or replaced with global options. See the 'Details' section.
}}

\item{fmt}{how to format numeric values: integer, user-supplied function, or \code{modelsummary} function.
\itemize{
\item Integer: Number of decimal digits
\item User-supplied functions:
\itemize{
\item Any function which accepts a numeric vector and returns a character vector of the same length.
}
\item \code{modelsummary} functions:
\itemize{
\item \code{fmt = fmt_significant(2)}: Two significant digits (at the term-level)
\item \code{fmt = fmt_sprintf("\%.3f")}: See \code{?sprintf}
\item \code{fmt = fmt_identity()}: unformatted raw values
}
}}

\item{title}{string}

\item{notes}{list or vector of notes to append to the bottom of the table.}

\item{align}{A string with a number of characters equal to the number of columns in
the table (e.g., \code{align = "lcc"}).  Valid characters: l, c, r, d.
\itemize{
\item "l": left-aligned column
\item "c": centered column
\item "r": right-aligned column
\item "d": dot-aligned column. For LaTeX/PDF output, this option requires at least version 3.0.25 of the siunitx LaTeX package. These commands must appear in the LaTeX preamble (they are added automatically when compiling Rmarkdown documents to PDF):
\itemize{
\item \verb{\\usepackage\{booktabs\}}
\item \verb{\\usepackage\{siunitx\}}
\item \verb{\\newcolumntype\{d\}\{S[ input-open-uncertainty=, input-close-uncertainty=, parse-numbers = false, table-align-text-pre=false, table-align-text-post=false ]\}}
}
}}

\item{add_columns}{a data.frame (or tibble) with the same number of rows as
your main table.}

\item{add_rows}{a data.frame (or tibble) with the same number of columns as
your main table. By default, rows are appended to the bottom of the table.
You can define a "position" attribute of integers to set the row positions.
See Examples section below.}

\item{sparse_header}{TRUE or FALSE. TRUE eliminates column headers which
have a unique label across all columns, except for the row immediately above
the data. FALSE keeps all headers. The order in which terms are entered in
the formula determines the order in which headers appear. For example,
\code{x~mean*z} will print the \code{mean}-related header above the \code{z}-related
header.`}

\item{escape}{boolean TRUE escapes or substitutes LaTeX/HTML characters which could
prevent the file from compiling/displaying. This setting does not affect captions or notes.}

\item{...}{all other arguments are passed through to the table-making
functions \link[kableExtra:kbl]{kableExtra::kbl}, \link[gt:gt]{gt::gt}, \link[DT:datatable]{DT::datatable}, etc. depending on the \code{output} argument.
This allows users to pass arguments directly to \code{datasummary} in order to
affect the behavior of other functions behind the scenes.}
}
\description{
Convenience function to tabulate counts, cell percentages, and row/column
percentages for categorical variables. See the Details section for a
description of the internal design. For more complex cross tabulations, use
\link{datasummary} directly. See the Details and Examples sections below,
and the vignettes on the \code{modelsummary} website:
\itemize{
\item https://vincentarelbundock.github.io/modelsummary/
\item https://vincentarelbundock.github.io/modelsummary/articles/datasummary.html
}
}
\details{
\code{datasummary_crosstab} is a wrapper around the \link{datasummary}
function. This wrapper works by creating a customized formula and by
feeding it to \code{datasummary}. The customized formula comes in two parts.

First, we take a two-sided formula supplied by the \code{formula} argument.
All variables of that formula are wrapped in a \code{Factor()} call to ensure
that the variables are treated as categorical.

Second, the \code{statistic} argument gives a two-sided formula which specifies
the statistics to include in the table. \code{datasummary_crosstab} modifies
this formula automatically to include "clean" labels.

Finally, the \code{formula} and \code{statistic} formulas are combined into a single
formula which is fed directly to the \code{datasummary} function to produce the
table.

Variables in \code{formula} are automatically wrapped in \code{Factor()}.
}
\section{Global Options}{


The behavior of \code{modelsummary} can be modified by setting global options. For example:
\itemize{
\item \code{options(modelsummary_model_labels = "roman")}
}

The rest of this section describes each of the options above.
\subsection{Model labels: default column names}{

These global option changes the style of the default column headers:
\itemize{
\item \code{options(modelsummary_model_labels = "roman")}
\item \code{options(modelsummary_panel_labels = "roman")}
}

The supported styles are: "model", "panel", "arabic", "letters", "roman", "(arabic)", "(letters)", "(roman)""

The panel-specific option is only used when \code{shape="rbind"}
}

\subsection{Table-making packages}{

\code{modelsummary} supports 4 table-making packages: \code{kableExtra}, \code{gt},
\code{flextable}, \code{huxtable}, and \code{DT}. Some of these packages have overlapping
functionalities. For example, 3 of those packages can export to LaTeX. To
change the default backend used for a specific file format, you can use
the \code{options} function:

\code{options(modelsummary_factory_html = 'kableExtra')}

\code{options(modelsummary_factory_latex = 'gt')}

\code{options(modelsummary_factory_word = 'huxtable')}

\code{options(modelsummary_factory_png = 'gt')}
}

\subsection{Table themes}{

Change the look of tables in an automated and replicable way, using the \code{modelsummary} theming functionality. See the vignette: https://vincentarelbundock.github.io/modelsummary/articles/appearance.html
\itemize{
\item \code{modelsummary_theme_gt}
\item \code{modelsummary_theme_kableExtra}
\item \code{modelsummary_theme_huxtable}
\item \code{modelsummary_theme_flextable}
\item \code{modelsummary_theme_dataframe}
}
}

\subsection{Model extraction functions}{

\code{modelsummary} can use two sets of packages to extract information from
statistical models: the \code{easystats} family (\code{performance} and \code{parameters})
and \code{broom}. By default, it uses \code{easystats} first and then falls back on
\code{broom} in case of failure. You can change the order of priorities or include
goodness-of-fit extracted by \emph{both} packages by setting:

\code{options(modelsummary_get = "broom")}

\code{options(modelsummary_get = "easystats")}

\code{options(modelsummary_get = "all")}
}

\subsection{Formatting numeric entries}{

By default, LaTeX tables enclose all numeric entries in the \verb{\\num\{\}} command
from the siunitx package. To prevent this behavior, or to enclose numbers
in dollar signs (for LaTeX math mode), users can call:

\code{options(modelsummary_format_numeric_latex = "plain")}

\code{options(modelsummary_format_numeric_latex = "mathmode")}

A similar option can be used to display numerical entries using MathJax in
HTML tables:

\code{options(modelsummary_format_numeric_html = "mathjax")}
}
}

\examples{
\dontrun{
  # crosstab of two variables, showing counts, row percentages, and row/column totals
  datasummary_crosstab(cyl ~ gear, data = mtcars)

  # crosstab of two variables, showing counts only and no totals
  datasummary_crosstab(cyl ~ gear, statistic = ~ N, data = mtcars)

  # crosstab of three variables
  datasummary_crosstab(am * cyl ~ gear, data = mtcars)
  
  # crosstab with two variables and column percentages 
  datasummary_crosstab(am ~ gear, statistic = ~ Percentage("col"), data = mtcars)
}

}
\references{
Arel-Bundock V (2022). “modelsummary: Data and Model Summaries in R.” \emph{Journal of Statistical Software}, \emph{103}(1), 1-23. \doi{10.18637/jss.v103.i01}.'
}
